package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

public enum ReconciliationStatusEnum {

    WAIT("0000","待推送"),
    CONFIRMED("0001", "待客户确认"),
    COMPLETE("0002","对账完成"),
    FAIL("0003","对账失败"),
    WITHDRAW("0004","对账撤回"),
    SCRAP("0005","对账作废");



    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private ReconciliationStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        ReconciliationStatusEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            ReconciliationStatusEnum calculationRulesEnum = var1[var3];
            codes.add(calculationRulesEnum.getCode());
        }

        return codes;
    }

    public static ReconciliationStatusEnum codeToEnum(String code) {
        ReconciliationStatusEnum calculationRules = null;
        ReconciliationStatusEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            ReconciliationStatusEnum calculationRulesEnum = var2[var4];
            if (calculationRulesEnum.code.equals(code)) {
                calculationRules = calculationRulesEnum;
            }
        }

        return calculationRules;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ReconciliationStatusEnum[] values = values();
            ReconciliationStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ReconciliationStatusEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            ReconciliationStatusEnum[] values = values();
            ReconciliationStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ReconciliationStatusEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }
}
