package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

@Getter
@AllArgsConstructor
public enum ReconciliationTypeEnum {

    APPROVAL("0000", "批复对账"),
    CLOSURE("0001", "结案对账"),
    COMMUNICATION("0002", "客户货款对账"),
    DISTRIBUTION("0004", "分销对账");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        for (ReconciliationTypeEnum value : values()) {
            codes.add(value.getCode());
        }
        return codes;
    }

    public static ReconciliationTypeEnum codeToEnum(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (ReconciliationTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public static String getDesc(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (ReconciliationTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value.getDes();
            }
        }
        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        for (ReconciliationTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

}
