package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import java.util.List;

/**
 * TPM-对账单据关联数据变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:00
 */
public interface ReconciliationCorrelationEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(ReconciliationCorrelationVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(ReconciliationCorrelationVo oldVo, ReconciliationCorrelationVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<ReconciliationCorrelationVo> list);

    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<ReconciliationCorrelationVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<ReconciliationCorrelationVo> list);
}
