package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;

import java.util.List;

/**
 * TPM-对账单据文件变更事件通知接口
 *
 * @author makejava
 * @date 2022-12-10 14:57:18
 */
public interface ReconciliationDocListFileEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(ReconciliationDocListFileVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(ReconciliationDocListFileVo oldVo, ReconciliationDocListFileVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<ReconciliationDocListFileVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<ReconciliationDocListFileVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<ReconciliationDocListFileVo> list);
}

