package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import java.util.List;

/**
 * TPM-任务执行日志变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-22 11:03:22
 */
public interface ReconciliationJobLogEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(ReconciliationJobLogVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(ReconciliationJobLogVo oldVo, ReconciliationJobLogVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<ReconciliationJobLogVo> list);

    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<ReconciliationJobLogVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<ReconciliationJobLogVo> list);
}
