package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * TPM-对账单据关联数据变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:01
 */
public interface ReconciliationCorrelationLogEventListener extends NebulaEvent {

    /**
     * 创建日志事件
     */
    void onCreate(ReconciliationCorrelationLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(ReconciliationCorrelationLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(ReconciliationCorrelationLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(ReconciliationCorrelationLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(ReconciliationCorrelationLogEventDto eventDto);

}
