package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * TPM-对账单据文件变更事件通知接口
 *
 * @author makejava
 * @date 2022-12-10 14:57:18
 */
public interface ReconciliationDocListFileLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(ReconciliationDocListFileLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(ReconciliationDocListFileLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(ReconciliationDocListFileLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(ReconciliationDocListFileLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(ReconciliationDocListFileLogEventDto eventDto);

}

