package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * TPM-任务执行日志变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-22 11:03:23
 */
public interface ReconciliationJobLogLogEventListener extends NebulaEvent {

    /**
     * 创建日志事件
     */
    void onCreate(ReconciliationJobLogLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(ReconciliationJobLogLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(ReconciliationJobLogLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(ReconciliationJobLogLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(ReconciliationJobLogLogEventDto eventDto);

}
