package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @ClassName ReconciliationSummaryDataDisplayLogEventListener
 * @Description 对账单汇总数据展示日志事件通知接口
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 14:31
 **/
public interface ReconciliationSummaryDataDisplayLogEventListener extends NebulaEvent {

    /**
     * 创建日志事件
     */
    void onCreate(ReconciliationSummaryDataDisplayLogDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(ReconciliationSummaryDataDisplayLogDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(ReconciliationSummaryDataDisplayLogDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(ReconciliationSummaryDataDisplayLogDto eventDto);
}
