package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Set;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import org.springframework.data.domain.Pageable;

/**
 * TPM-对账单据关联数据(ReconciliationCorrelation)表服务接口
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:00
 */
public interface ReconciliationCorrelationVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ReconciliationCorrelationVo> findByConditions(Pageable pageable, ReconciliationCorrelationDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    ReconciliationCorrelationVo findDetailById(String id);


    /**
     * 根据对账编码查询
     *
     * @param statementCode 对账编码
     * @return {@link Set}<{@link String}>
     */
    Set<String> findByStatementCode(String statementCode);


    /**
     * 创建
     *
     * @param reconciliationCorrelationVo
     * @return
     */
    ReconciliationCorrelationVo create(ReconciliationCorrelationVo reconciliationCorrelationVo);


    /**
     * 创建批处理
     *
     * @param voList vo列表
     */
    void createBatch(List<ReconciliationCorrelationVo> voList);


    /**
     * 更新
     *
     * @param reconciliationCorrelationVo
     * @return
     */
    ReconciliationCorrelationVo update(ReconciliationCorrelationVo reconciliationCorrelationVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);
}
