package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Set;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import org.springframework.data.domain.Pageable;

/**
 * 和解医生列表文件vo服务 TPM-对账单据文件(ReconciliationDocListFile)表服务接口
 *
 * @author makejava
 * @date 2022-12-10 14:57:18
 */
public interface ReconciliationDocListFileVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ReconciliationDocListFileVo> findByConditions(Pageable pageable, ReconciliationDocListFileDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    ReconciliationDocListFileVo findDetailById(String id);


    /**
     * 根据关联编码与文件类型查询文件详情vo
     * @param statementCode 关联编码
     * @param fileType 文件类型
     * @return 文件详情vo
     */
    ReconciliationDocListFileVo findDetailByStatementCodeAndFileType(String statementCode,String fileType);

    /**
     * 创建
     *
     * @param reconciliationDocListFileVo
     * @return
     */
    ReconciliationDocListFileVo create(ReconciliationDocListFileVo reconciliationDocListFileVo);

    /**
     * 更新
     *
     * @param reconciliationDocListFileVo
     * @return
     */
    ReconciliationDocListFileVo update(ReconciliationDocListFileVo reconciliationDocListFileVo);


    /**
     * 批量创建
     * @param files 文件列表
     */
    void createBatch(Set<ReconciliationDocListFileVo> files);
}
