package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import org.springframework.data.domain.Pageable;

import java.io.IOException;
import java.util.Date;
import java.util.List;

/**
 * 对账单据列表(ReconciliationDocListEntity)表服务接口
 *
 * @author youjun
 * @date 2022年11月17日 10:52
 */
public interface ReconciliationDocListService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param reconciliationDocListDto 实体对象
   * @return
   */
  Page<ReconciliationDocListVo> findByReconciliations(Pageable pageable, ReconciliationDocListDto reconciliationDocListDto);

  /**
   * 修改新据
   * @param reconciliationDocListDto 实体对象
   * @return 修改结果
   */
  ReconciliationDocListVo update(ReconciliationDocListDto reconciliationDocListDto);


  /**
   * 重新生成对账单
   *
   * @param ids id
   */
  void regenerate(List<String> ids);

  /**
   * 批量创建对账单据列表
   * @param reconciliationDocListVos 对账单据列表
   */
  List<String> createBatch(List<ReconciliationDocListVo> reconciliationDocListVos);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ReconciliationDocListVo findById(String id);

  /**
   * 根据合同编码查询
   * @param contractId 合同编码
   * @return 对账单
   */
  ReconciliationDocListVo findByContractId(String contractId);


  /**
   * 推送电子签章
   * @param ids 数据主键列表
   * @return 结果
   */
  void pushAccountCheckBill(List<String> ids);

  /**
   * 作废电子签章
   * @param ids 数据主键列表
   * @return 结果
   */
  void cancellationContract(List<String> ids);

  /**
   * 撤回电子签章
   * @param ids 数据主键列表
   * @return 结果
   */
  void withdrawalContract(List<String> ids);

  /**
   * 查看电子签章
   *
   * @param ids 数据主键列表
   * @return {@link List}<{@link ReconciliationDocListFileVo}>
   */
  List<ReconciliationDocListFileVo> browseContract(List<String> ids);

  /**
   * 下载电子签章
   *
   * @param ids 数据主键列表
   * @return {@link List}<{@link ReconciliationDocListFileVo}>
   */
  List<ReconciliationDocListFileVo> downloadContract(List<String> ids);

  /**
   * 根据id下载压缩包
   * @param ids id列表
   * @return byte[]
   * @throws IOException 异常
   */
  byte[] findFileZipByIds(List<String> ids) throws IOException;

  /**
   * 催签电子签章
   * @param ids 数据主键列表
   * @return 结果
   */
  void contractExpediting(List<String> ids);

  /**
   * 根据选择的对账规则和对应的计算时间手动生成生效范围对应的对账函
   * @param date
   */
  void autoBuildReconciliation(Date date);

  /**
   * 能力中心生成对账单数据
   * @param date
   */
  List<String> handleManualGenerate(Date date);

  /**
   * 重新执行的失败的任务
   * @param date
   */
  void autoBuildFailReconciliation(Date date);


  List<String> autoBuildReconciliationForOut(Date date);

  Page<ReconciliationDocListVo> findPageForOut(Pageable pageable, ReconciliationDocListDto dto);
}
