package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import org.springframework.data.domain.Pageable;

/**
 * TPM-任务执行日志(ReconciliationJobLog)表服务接口
 *
 * @author liuyifan
 * @date 2023-02-22 11:03:22
 */
public interface ReconciliationJobLogVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ReconciliationJobLogVo> findByConditions(Pageable pageable, ReconciliationJobLogDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    ReconciliationJobLogVo findDetailById(String id);

    /**
     * 创建
     *
     * @param reconciliationJobLogVo
     * @return
     */
    ReconciliationJobLogVo create(ReconciliationJobLogVo reconciliationJobLogVo);

    /**
     * 更新
     *
     * @param reconciliationJobLogVo
     * @return
     */
    ReconciliationJobLogVo update(ReconciliationJobLogVo reconciliationJobLogVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 找到独特job信息
     *
     * @param dto dto
     * @return {@link ReconciliationJobLogVo}
     */
    ReconciliationJobLogVo findUniqueJobInfo(ReconciliationJobLogDto dto);
}
