package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.PullSapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

public interface SapReconciliationService {
    /**
     * sap客户对账数据-ZMSD123接口，150客户对账
     */
    Result querySapReconciliation(PullSapReconciliationDto dto);

    void testReconciliationCallback(ReconciliationCallbackDto Dto);

    /**
     * 查询客户编码
     * @param dto
     * @return
     */
    Set<String> findCustomer(SapReconciliationDto dto);

    /**
     * 生成对账单时查询SAP拉取的对账数据
     * @param dto
     * @return
     */
    List<SapReconciliationVo> findListByCustomerCode(SapReconciliationDto dto);

    /**
     * 分页
     * @param pageable
     * @param sapReconciliationDto
     * @return
     */
    Page<SapReconciliationVo> findByReconciliations(Pageable pageable, SapReconciliationDto sapReconciliationDto);

    /**
     * 定时任务拉取123数据
     */
    void sync123DataScheduleTask();
}
