package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationGenerateAsyncService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationPdfService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.ReconciliationUtils;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationAsyncResult;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-15
 */
@Slf4j
@Service
public class ReconciliationGenerateAsyncServiceImpl implements ReconciliationGenerateAsyncService {

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ReconciliationPdfService reconciliationPdfService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @Async("reconciliationAsyncThread")
    public Future<ReconciliationAsyncResult> cal(String customerCode,
                                                 String type,
                                                 Date docStartTime,
                                                 Date docEndTime,
                                                 ReconciliationGenerateDto generateDto,
                                                 UserIdentity loginUser,
                                                 AbstractReconciliationGenerateStrategy abstractReconciliationGenerateStrategy,
                                                 Map<String, List<TerminalVo>> terminalMap,
                                                 Map<String, List<CustomerVo>> customerMap, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        log.info("生成对账单customerCode{}", customerCode);
        ReconciliationAsyncResult result = new ReconciliationAsyncResult();
        try {
            loginUserService.refreshAuthentication(loginUser);
            if (StringUtils.isEmpty(customerCode)) {
                log.info("生成对账单customerCode===>为空");
                return AsyncResult.forValue(result);
            }
            CustomerVo customerVo = null;
            ReconciliationSummaryDataDisplayDto displayDto = new ReconciliationSummaryDataDisplayDto();

            if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), type)) {
                if (CollectionUtil.isNotEmpty(terminalMap.get(customerCode))) {
                    customerVo = customerMap.get(customerCode).get(0);
                    SalesOrgSubComOrgVo salesOrgSubComOrgVo = salesOrgSubComOrgVoMap.get(customerVo.getSalesInstitutionErpCode());
                    if(salesOrgSubComOrgVo != null){
                        displayDto.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                        displayDto.setOrgName(salesOrgSubComOrgVo.getOrgName());
                    }
                }
            } else {
                if (CollectionUtil.isNotEmpty(customerMap.get(customerCode))) {
                    customerVo = customerMap.get(customerCode).get(0);
                }
            }
            if (Objects.nonNull(customerVo)){
                displayDto.setChannelCode(customerVo.getChannel());
                displayDto.setSalesInstitutionCode(customerVo.getSalesInstitutionCode());
                displayDto.setSalesInstitutionErpCode(customerVo.getSalesInstitutionErpCode());
                displayDto.setSalesInstitutionName(customerVo.getSalesInstitutionName());
                displayDto.setSalesRegionCode(customerVo.getSalesRegionCode());
                displayDto.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
                displayDto.setSalesRegionName(customerVo.getSalesRegionName());
                displayDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                displayDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                displayDto.setSalesOrgName(customerVo.getSalesOrgName());

                displayDto.setCustomerCode(customerVo.getErpCode());
                displayDto.setCustomerName(customerVo.getCustomerName());
            }
            //4.1 构建vo对象
            ReconciliationDocListVo reconciliationDocListVo = ReconciliationUtils.buildReconciliationVo(generateDto, customerMap, customerCode, docStartTime, docEndTime, terminalMap, type,salesOrgSubComOrgVoMap);
            if (Objects.isNull(reconciliationDocListVo)) {
                log.info("生成对账单customerCode{}reconciliationDocListVo(customerMap)===>为空", customerCode);
                return AsyncResult.forValue(result);
            }
            reconciliationDocListVo.setAccountReconciliationType(abstractReconciliationGenerateStrategy.getReconciliationType());

            List<String> codeList = this.generateCodeService.generateCode(ReconciliationConstant.RECONCILIATION_CODE, 1, 8, 2, TimeUnit.DAYS);
            reconciliationDocListVo.setStatementCode(codeList.get(0));

            //4.2 获取数据集
            log.info("customerCode{}对账单开始查询数据", customerCode);
            List itemVos = abstractReconciliationGenerateStrategy.findDateList(generateDto, customerCode);
            if (CollectionUtils.isEmpty(itemVos)) {
                log.info("生成对账单customerCode:{}，itemVos===>为空", customerCode);
                return AsyncResult.forValue(result);
            }

            //4.3 生成pdf

            displayDto.setBusinessUnitCode(generateDto.getBusinessUnitCode());
            displayDto.setBusinessFormatCode(generateDto.getBusinessFormatCode());
            displayDto.setReconciliationType(abstractReconciliationGenerateStrategy.getReconciliationType());
            displayDto.setStatementCode(reconciliationDocListVo.getStatementCode());
            displayDto.setTenantCode(TenantUtils.getTenantCode());
            displayDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            displayDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());

            log.info("生成对账单customerCode{}，开始生成pdf", customerCode);
            reconciliationPdfService.generatePdf(reconciliationDocListVo, itemVos, abstractReconciliationGenerateStrategy, displayDto);
            log.info("生成对账单customerCode{}，生成pdf结束", customerCode);

            log.info("对账单年月{}", reconciliationDocListVo.getReconciliationMonth());
            //对账年月
            displayDto.setReconciliationYearMonth(DateUtil.format(reconciliationDocListVo.getReconciliationMonth(), DatePattern.NORM_MONTH_FORMAT));

            result.setDisplayDto(displayDto);

            //4.4 构建关联表
            log.info("开始构建关联表");
            List<ReconciliationCorrelationVo> voList = new ArrayList<>(itemVos.size());
            itemVos.forEach(item -> {
                if (item == null) {
                    return;
                }
                ReconciliationCorrelationVo reconciliationCorrelationVo = new ReconciliationCorrelationVo();
                reconciliationCorrelationVo.setStatementCode(reconciliationDocListVo.getStatementCode());
                reconciliationCorrelationVo.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
                reconciliationCorrelationVo.setBusinessType(abstractReconciliationGenerateStrategy.getBusinessType());

                //获取关联id
                try {
                    List<Field> fields = new ArrayList<>();
                    Class aClass = item.getClass();
                    while (aClass != null) {
                        fields.addAll(Arrays.asList(aClass.getDeclaredFields()));
                        aClass = aClass.getSuperclass();
                    }
                    Optional<Field> first = fields.stream().filter(x -> x.getName().equals("id")).findFirst();
                    if (first.isPresent()) {
                        Field field = first.get();
                        field.setAccessible(true);
                        reconciliationCorrelationVo.setAssociativeDate(String.valueOf(field.get(item)));
                    }
                    // 取活动名称
                    Optional<Field> activityNameFirst = fields.stream().filter(x -> x.getName().equals("activityName")).findFirst();
                    if (activityNameFirst.isPresent()) {
                        Field field = activityNameFirst.get();
                        field.setAccessible(true);
                        log.info("生成对账单活动名称 activityName:{}", field.get(item));
                        reconciliationDocListVo.setActivityName(String.valueOf(field.get(item)));
                    }
                } catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("对账单转换关联表单,属性转换错误", e);
                }

                voList.add(reconciliationCorrelationVo);
            });

            reconciliationDocListVo.setCorrelations(voList);
            result.setReconciliationDocListVo(reconciliationDocListVo);
            log.info("结束构建关联表");
        } catch (NullPointerException npe) {
            log.info("进入空指针异常处理");
            log.error("", npe);
            result.setExceptionMsg("客户[" + customerCode + "]空指针异常");
        } catch (Exception e) {
            log.info("进入其他异常处理");
            log.error("", e);
            result.setExceptionMsg(e.getMessage());
        }
        return AsyncResult.forValue(result);
    }

}
