package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CustomXMLWorkerFontProvider extends XMLWorkerFontProvider {
    @Override
    public Font getFont(final String fontName, final String encoding, final boolean embedded, final float size, final int style,
                        final BaseColor color) {
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.EMBEDDED);
            Font font = new Font(bf, size, style, color);
            font.setColor(color);
            return font;
        } catch (Exception e) {
            log.error("exception:", e);
        }
        return null;
    }
}
