package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;

import java.util.*;

@Slf4j
public class ReconciliationUtils {

    public static ReconciliationDocListVo buildReconciliationVo(ReconciliationGenerateDto reconciliationGenerateDto,
                                                                Map<String, List<CustomerVo>> customerMap, String customerCode, Date startTime, Date endTime, Map<String, List<TerminalVo>> terminalMap, String type, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        ReconciliationDocListVo reconciliationDocListVo = new ReconciliationDocListVo();
        reconciliationDocListVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationDocListVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        reconciliationDocListVo.setTenantCode(TenantUtils.getTenantCode());
        reconciliationDocListVo.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        reconciliationDocListVo.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        reconciliationDocListVo.setStartDate(startTime);
        reconciliationDocListVo.setEndDate(endTime);
        reconciliationDocListVo.setStatementStatus(ReconciliationStatusEnum.WAIT.getCode());
        reconciliationDocListVo
            .setAccountReconciliationRuleCode(reconciliationGenerateDto.getAccountReconciliationRuleCode());
        reconciliationDocListVo.setReconciliationMonth(reconciliationGenerateDto.getStartDateTime());

        if(BusinessUnitEnum.SON_COMPANY.getCode().equals(type)){
            if (CollectionUtils.isEmpty(customerMap.get(customerCode))){
                return null;
            }
            CustomerVo customer = customerMap.get(customerCode).get(0);

            log.info("生成对账单客户信息:customer:{}", JsonUtils.obj2JsonString(customer));
            SalesOrgSubComOrgVo salesOrgSubComOrgVo = salesOrgSubComOrgVoMap.get(customer.getSalesInstitutionErpCode());
            log.info("生成对账单hr组织和销售组织关系:salesOrgSubComOrgVo:{}", JsonUtils.obj2JsonString(salesOrgSubComOrgVo));
            if(salesOrgSubComOrgVo != null){
                reconciliationDocListVo.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                reconciliationDocListVo.setOrgName(salesOrgSubComOrgVo.getOrgName());
            }
            reconciliationDocListVo.setCustomerName(customer.getCustomerName());
            reconciliationDocListVo.setCustomerCode(customer.getErpCode());
            reconciliationDocListVo.setCustomerErpCode(customer.getErpCode());
            reconciliationDocListVo.setSalesOrgName(customer.getSalesRegionName());
            reconciliationDocListVo.setSalesOrgCode(customer.getSalesRegionCode());
            reconciliationDocListVo.setSalesGroupName(customer.getSalesOrgName());
            reconciliationDocListVo.setSalesGroupCode(customer.getSalesOrgCode());
            reconciliationDocListVo.setSalesInstitutionName(customer.getSalesInstitutionName());
            reconciliationDocListVo.setSalesInstitutionCode(customer.getSalesInstitutionCode());
            reconciliationDocListVo.setSalesInstitutionErpCode(customer.getSalesInstitutionErpCode());
            reconciliationDocListVo.setCustomerChannelCode(customer.getCustomerChannelCode());
            reconciliationDocListVo.setCustomerBusinessFormatCode(customer.getBusinessFormatCode());

            reconciliationDocListVo.setRecipientName(customer.getReconReceiveName());
            reconciliationDocListVo.setReceiverTelephone(customer.getReconReceivePhone());
            reconciliationDocListVo.setRecipientEmail(customer.getReconReceiveEmail());
        }else {
            if (CollectionUtils.isEmpty(customerMap.get(customerCode))){
                return null;
            }
            CustomerVo customer = customerMap.get(customerCode).get(0);
            reconciliationDocListVo.setCustomerName(customer.getCustomerName());
            reconciliationDocListVo.setCustomerCode(customerCode);
            reconciliationDocListVo.setCustomerErpCode(customer.getErpCode());
            reconciliationDocListVo.setSalesOrgName(customer.getSalesRegionName());
            reconciliationDocListVo.setSalesOrgCode(customer.getSalesRegionCode());
            reconciliationDocListVo.setSalesGroupName(customer.getSalesOrgName());
            reconciliationDocListVo.setSalesGroupCode(customer.getSalesOrgCode());
            reconciliationDocListVo.setSalesInstitutionName(customer.getSalesInstitutionName());
            reconciliationDocListVo.setSalesInstitutionCode(customer.getSalesInstitutionCode());
            reconciliationDocListVo.setSalesInstitutionErpCode(customer.getSalesInstitutionErpCode());

            reconciliationDocListVo.setRecipientName(customer.getReconReceiveName());
            reconciliationDocListVo.setReceiverTelephone(customer.getReconReceivePhone());
            reconciliationDocListVo.setRecipientEmail(customer.getReconReceiveEmail());
        }

        return reconciliationDocListVo;
    }
}
