package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/7/19 20:30
 */
@ApiModel("分销对账单数据vo")
@Data
public class DistributionReconciliationAuditVo extends TenantFlagOpVo {

    @ApiModelProperty("年月")
    private String yearMonth;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户编码")
    private String sapCustomerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productCode;
    
    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("供货价（元）")
    private BigDecimal supplyPrice;

    @ApiModelProperty("销售数量")
    private Integer monthSaleQuantity;

    @ApiModelProperty("订货金额")
    private BigDecimal monthSaleAmount;

    @ApiModelProperty("核销数量")
    private BigDecimal auditQuantity;

    @ApiModelProperty("捆赠销售数量（箱）")
    private Integer boundGiftSaleQuantity;

    @ApiModelProperty("基础数量")
    private Integer baseQuantity;

    @ApiModelProperty("组合装费用")
    private BigDecimal combinationFee;

    @ApiModelProperty("基础旬返费用")
    private BigDecimal distributionBaseTen;

    @ApiModelProperty("基础目标返费用")
    private BigDecimal goalAchievement;

    @ApiModelProperty("基础月返")
    private BigDecimal month;

    @ApiModelProperty("实际人员返点")
    private BigDecimal staffFee;

    @ApiModelProperty("物流数量")
    private Integer logisticsQuantity;

    @ApiModelProperty("物流费用（元）")
    private BigDecimal logistics;

    @ApiModelProperty("季返")
    private BigDecimal quarter;

    @ApiModelProperty("其他支持1")
    private BigDecimal otherCooperation;

    @ApiModelProperty("其他支持2")
    private BigDecimal otherCooperationTwo;

    @ApiModelProperty("罚款")
    private BigDecimal fine;

    @ApiModelProperty("上月上账")
    private BigDecimal lastMonthAccount;

    @ApiModelProperty("基础返当月上账")
    private BigDecimal monthAccount;

    @ApiModelProperty("人员物流当月上账")
    private BigDecimal staffLogistics;
}
