package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * TPM-对账单据关联数据vo
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-对账单据关联数据Vo")
public class ReconciliationCorrelationVo extends TenantFlagOpVo {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    private String statementCode;


    /**
     * 对账单类型
     */
    @ApiModelProperty(name = "accountReconciliationType",value = "对账单类型",notes = "对账单类型")
    private String accountReconciliationType;


    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType",value = "业务类型",notes = "业务类型")
    private String businessType;


    /**
     * 关联数据编码ID
     */
    @ApiModelProperty(name = "associative_date",value = "关联数据编码ID",notes = "关联数据编码ID")
    private String associativeDate;

}
