package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author youjun
 * @date 2022年11月17日 10:50
 */
@ApiModel(value = "对账单据列表vo")
@Data
public class ReconciliationDocListVo extends TenantFlagOpVo {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    private String statementCode;

    /**
     * 对账单状态
     */
    @ApiModelProperty(name = "statementStatus",value = "对账单状态",notes = "对账单状态")
    private String statementStatus;
    /**
     * 对账年月
     */
    @ApiModelProperty(name = "reconciliationMonth",value = "对账年月", notes = "对账年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    private Date reconciliationMonth;
    /**
     * 对账单类型
     */
    @ApiModelProperty(name = "accountReconciliationType",value = "对账单类型",notes = "对账单类型")
    private String accountReconciliationType;
    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitName",value = "业务单元",notes = "业务单元")
    private String businessUnitName;

    @ApiModelProperty(name = "businessUnitName",value = "编码",notes = "业务单元")
    private String businessUnitCode;

    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "计算开始时间", notes = "")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;


    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "计算结束时间", notes = "")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 销售部门(大区)
     */
    @ApiModelProperty(name = "salesOrgName",value = "销售部门(大区)",notes = "销售部门(大区)")
    private String salesOrgName;
    /**
     * 销售组(省区)
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组(省区)",notes = "销售组(省区)")
    private String salesGroupName;
    /**
     * 销售机构
     */
    @ApiModelProperty(name = "salesOrganization",value = "销售机构",notes = "销售机构")
    private String salesOrganization;
    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    private String salesOrgCode;
    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;
    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    private String salesInstitutionCode;
    /**
     * 销售机构erp编码
     */
    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构erp编码",notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    private String salesInstitutionName;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    private String customerCode;
    @ApiModelProperty(name = "customerErpCode",value = "客户MDG编码",notes = "客户MDG编码")
    private String customerErpCode;
    /**
     * 接收人姓名
     */
    @ApiModelProperty(name = "recipientName",value = "接收人姓名",notes = "接收人姓名")
    private String recipientName;
    /**
     * 接收人手机号
     */
    @ApiModelProperty(name = "receiverTelephone",value = "接收人手机号",notes = "接收人手机号")
    private String receiverTelephone;
    /**
     * 接收人邮箱
     */
    @ApiModelProperty(name = "recipientEmail",value = "接收人邮箱",notes = "接收人邮箱")
    private String recipientEmail;
    /**
     * 对账单完成时间
     */
    @ApiModelProperty(name = "statementCompletionTime",value = "对账单完成时间", notes = "对账单完成时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date statementCompletionTime;
    /**
     * 客户拒绝签单原因
     */
    @ApiModelProperty(name = "reasonForRejection",value = "客户拒绝签单原因",notes = "客户拒绝签单原因")
    private String reasonForRejection;
    /**
     * 对账标记
     */
    @ApiModelProperty(name = "reconciliationFlag",value = "对账标记",notes = "对账标记")
    private String reconciliationFlag;


    @ApiModelProperty(name = "accountReconciliationRuleCode",value = "对账规则编码",notes = "对账规则编码")
    private String accountReconciliationRuleCode;

    @ApiModelProperty(name = "活动申请名称", notes = "活动申请名称")
    private String activityName;

    @ApiModelProperty("合同id")
    private String contractId;

    @ApiModelProperty("文档id")
    private String documentsId;

    @ApiModelProperty("hr组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty(name = "files",value = "文件列表",notes = "文件列表")
    private List<ReconciliationDocListFileVo> files;

    @ApiModelProperty(name = "correlations",value = "关联表单",notes = "关联表单")
    private List<ReconciliationCorrelationVo> correlations;

    //临时字段
    @ApiModelProperty("客户分销渠道编码")
    private String customerChannelCode;
    @ApiModelProperty("客户业态")
    private String customerBusinessFormatCode;

}
