package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.persistence.Column;
import java.util.Date;

/**
 * TPM-任务执行日志vo
 *
 * @author liuyifan
 * @date 2023-02-22 11:03:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-任务执行日志Vo")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReconciliationJobLogVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "executionStartTime", value = "执行开始时间", notes = "执行开始时间")
    private Date executionStartTime;

    @ApiModelProperty(name = "statementCode", value = "执行结束时间", notes = "执行结束时间")
    private Date executionEndTime;

    @ApiModelProperty(name = "executionMillisecond", value = "执行耗时（毫秒）", notes = "执行耗时（毫秒）")
    private Integer executionMillisecond;

    @ApiModelProperty(name = "isSuccess", value = "是否成功", notes = "是否成功")
    private Boolean isSuccess;

    @ApiModelProperty(name = "errorMsg", value = "错误信息", notes = "错误信息")
    private String errorMsg;

    @ApiModelProperty(name = "retryTimes", value = "失败重试次数", notes = "失败重试次数")
    private Integer retryTimes;

    /**
     * 业态编码
     */
    @ApiModelProperty(value = "businessFormatCode", notes = "业态编码")
    private String businessFormatCode;

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "startDate", notes = "计算开始时间")
    private Date startDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "endDate", notes = "计算结束时间")
    private Date endDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "calculationTime", notes = "计算时间")
    private Date calculationTime;

    @ApiModelProperty(name = "accountReconciliationRuleCode",value = "对账规则编码",notes = "对账规则编码")
    private String accountReconciliationRuleCode;

    @ApiModelProperty(name = "accountReconciliationType",value = "对账类型",notes = "对账类型")
    private String accountReconciliationType;


}
