package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 主体批复对账单明细表
 *
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailHeadApproveVo", description = "TPM-主体批复对账单明细表")
@Data
@CrmExcelExport
public class ReconciliationSummaryDataDisplayDetailHeadApproveExportVo extends CrmExcelVo {

    @ApiModelProperty(name = "statementCode", value = "对账单编码", notes = "对账单编码")
    @CrmExcelColumn("对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构ERP编码", notes = "销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("销售大区编码")
    @CrmExcelColumn("销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty(name = "salesRegionName", value = "销售大区", notes = "销售大区")
    @CrmExcelColumn("销售大区")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "activityFormCode", value = "活动形式编码", notes = "活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", value = "活动形式名称", notes = "活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "productBrandCode", value = "品牌编码", notes = "品牌编码")
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", value = "品牌名称", notes = "品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @ApiModelProperty(name = "productCode", value = "产品编码", notes = "产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;

    @ApiModelProperty(name = "productName", value = "产品名称", notes = "产品名称")
    @CrmExcelColumn("产品名称")
    private String productName;

    @ApiModelProperty("费用合计")
    @CrmExcelColumn("费用合计")
    private BigDecimal totalFee;

    @ApiModelProperty("费用申请")
    @CrmExcelColumn("费用申请")
    private BigDecimal applyFee;

    @ApiModelProperty("客户承担费用")
    @CrmExcelColumn("客户承担费用")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty("活动开始时间")
    @CrmExcelColumn("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @CrmExcelColumn("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndDate;

}
