package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 主体批复对账单明细表
 *
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailHeadApproveVo", description = "TPM-主体批复对账单明细表")
@Data
public class ReconciliationSummaryDataDisplayDetailHeadApproveVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "statementCode", value = "对账单编码", notes = "对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构ERP编码", notes = "销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "activityFormCode", value = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", value = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码", notes = "预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName", value = "预算项目名称", notes = "预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("产品品牌编码")
    private String productBrandCode;

    @ApiModelProperty("产品品牌名称")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    private String productCategoryName;

    @ApiModelProperty("费用合计")
    private BigDecimal totalFee;

    @ApiModelProperty("费用申请")
    private BigDecimal applyFee;

    @ApiModelProperty("客户承担费用")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndDate;

}
