package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 分子结案对账单明细表
 *
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailSubAuditVo", description = "TPM-分子结案对账单明细表")
@Data
@CrmExcelExport
public class ReconciliationSummaryDataDisplayDetailSubAuditExportVo extends CrmExcelVo {

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "statementCode", value = "对账单编码", notes = "对账单编码")
    @CrmExcelColumn("对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "channelCode", value = "渠道编码", notes = "渠道编码")
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 销售组
     */
    @ApiModelProperty(name = "salesGroupName", value = "销售组", notes = "销售组")
    @CrmExcelColumn("销售组")
    private String salesGroupName;

    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode", value = "销售组编码", notes = "销售组编码")
    @CrmExcelColumn("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;

    @ApiModelProperty(name = "activityFormCode", value = "活动形式编码", notes = "活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", value = "活动形式名称", notes = "活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码", notes = "预算项目编码")
    @CrmExcelColumn("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName", value = "预算项目名称", notes = "预算项目名称")
    @CrmExcelColumn("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty(name = "productBrandCode", value = "品牌编码", notes = "品牌编码")
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", value = "品牌名称", notes = "品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @ApiModelProperty("活动开始时间")
    @CrmExcelColumn("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @CrmExcelColumn("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    @ApiModelProperty("批复金额")
    @CrmExcelColumn("批复金额")
    private BigDecimal approveAmount;

    @ApiModelProperty(name = "handling", value = "处理方式", notes = "处理方式")
    @CrmExcelColumn("处理方式")
    private String handling;

    @ApiModelProperty(name = "currentHandleAmount", value = "本次应处理金额", notes = "本次应处理金额")
    @CrmExcelColumn("本次应处理金额")
    private BigDecimal currentHandleAmount;
}
