package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 分子往来对账单明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailSubCommunicateVo", description = "TPM-分子往来对账单明细表")
@Data
@CrmExcelExport
public class ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo extends CrmExcelVo {

    @ApiModelProperty(name = "businessUnitCode", value = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @CrmExcelColumn("对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "vkorg",value = "销售机构",notes = "销售机构")
    @CrmExcelColumn("销售机构")
    private String vkorg;

    @ApiModelProperty("分销渠道")
    @CrmExcelColumn("分销渠道")
    private String vtweg;

    @ApiModelProperty("渠道描述")
    @CrmExcelColumn("渠道描述")
    private String vtext;

    @ApiModelProperty("售达方")
    @CrmExcelColumn("售达方")
    private String kunrg;

    @ApiModelProperty("客户全称")
    @CrmExcelColumn("客户全称")
    private String kunagTxt;

    @ApiModelProperty("日期")
    @CrmExcelColumn("日期")
    private String fkdat;

    @ApiModelProperty("财务单据名称")
    @CrmExcelColumn("财务单据名称")
    private String zdocName;

    @ApiModelProperty("实收金额")
    @CrmExcelColumn("实收金额")
    private String zsh;

    @ApiModelProperty("付款方式")
    @CrmExcelColumn("付款方式")
    private String zfkfs;

    @ApiModelProperty("预收账款变动原因")
    @CrmExcelColumn("预收账款变动原因")
    private String zyszkBdyy;

    @ApiModelProperty("销售发票编号")
    @CrmExcelColumn("销售发票编号")
    private String vbeln;

    @ApiModelProperty("发票行项目")
    @CrmExcelColumn("发票行项目")
    private String posnr;

    @ApiModelProperty("订单行项目类别")
    @CrmExcelColumn("订单行项目类别")
    private String pstyv;

    @ApiModelProperty("订单行项目类别")
    @CrmExcelColumn("订单行项目类别")
    private String pstyvT;

    @ApiModelProperty("会计凭证")
    @CrmExcelColumn("会计凭证")
    private String belnr;

    @ApiModelProperty("销售订单编号")
    @CrmExcelColumn("销售订单编号")
    private String aubel;

    @ApiModelProperty("交货单编号")
    @CrmExcelColumn("交货单编号")
    private String vgbel;

    @ApiModelProperty("商品")
    @CrmExcelColumn("商品")
    private String arktx;

    @ApiModelProperty("标准价")
    @CrmExcelColumn("标准价")
    private String netwrHs;

    @ApiModelProperty("实际价")
    @CrmExcelColumn("实际价")
    private String netwrZk;

    @ApiModelProperty("折扣率(%)")
    @CrmExcelColumn("折扣率(%)")
    private String ratio;

    @ApiModelProperty("数量")
    @CrmExcelColumn("数量")
    private String fkimg;

    @ApiModelProperty("单位")
    @CrmExcelColumn("单位")
    private String vrkme;

    @ApiModelProperty("基本单位数量")
    @CrmExcelColumn("基本单位数量")
    private String fklmg;

    @ApiModelProperty("基本单位")
    @CrmExcelColumn("基本单位")
    private String meins;

    @ApiModelProperty("折扣金额")
    @CrmExcelColumn("折扣金额")
    private String kzwi6;

    @ApiModelProperty("应收金额")
    @CrmExcelColumn("应收金额")
    private String kzwi1;

    @ApiModelProperty("应收余额")
    @CrmExcelColumn("应收余额")
    private String zysye;

    @ApiModelProperty("随单费用折扣值")
    @CrmExcelColumn("随单费用折扣值")
    private String zsdfy;

    @ApiModelProperty("发票固定折扣值")
    @CrmExcelColumn("发票固定折扣值")
    private String zk01;

    @ApiModelProperty("发票费用折扣值")
    @CrmExcelColumn("发票费用折扣值")
    private String zfpfy;

    @ApiModelProperty("商品编号")
    @CrmExcelColumn("商品编号")
    private String matnr;

    @ApiModelProperty("送达方")
    @CrmExcelColumn("送达方")
    private String kunwe;

    @ApiModelProperty("送达方名称")
    @CrmExcelColumn("送达方名称")
    private String kunweTxt;

    @ApiModelProperty("客户订单号")
    @CrmExcelColumn("客户订单号")
    private String bstnk;

    @ApiModelProperty("利润中心")
    @CrmExcelColumn("利润中心")
    private String prctr;

}
