package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName ReconciliationSummaryDataDisplayLogVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 14:35
 **/
@Data
public class ReconciliationSummaryDataDisplayLogVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "reconciliationType",value = "对账单编码",notes = "对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "reconciliationType",value = "对账单类型",notes = "对账单类型")
    private String reconciliationType;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "channelCode",value = "渠道编码",notes = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "customerErpCode",value = "ECRM客户编码",notes = "ECRM客户编码")
    private String customerErpCode;

    @ApiModelProperty(name = "reconciliationYearMonth",value = "对账年月",notes = "对账年月")
    private String reconciliationYearMonth;

    @ApiModelProperty(name = "thisMonthFeeTotalAmount",value = "本月费用合计金额（元）",notes = "本月费用合计金额（元）")
    private BigDecimal thisMonthFeeTotalAmount;

    @ApiModelProperty(name = "thisMonthFeeApplyAmount",value = "本月费用申请金额（元）",notes = "本月费用申请金额（元）")
    private BigDecimal thisMonthFeeApplyAmount;

    @ApiModelProperty(name = "thisMonthCustomerBearTotalAmount",value = "本月客户承担合计金额（元）",notes = "本月客户承担合计金额（元）")
    private BigDecimal thisMonthCustomerBearTotalAmount;

    @ApiModelProperty(name = "promotionTotalAmount",value = "报销合计金额",notes = "报销合计金额")
    private BigDecimal promotionTotalAmount;

    @ApiModelProperty(name = "discountTotalAmount",value = "折扣合计金额",notes = "折扣合计金额")
    private BigDecimal discountTotalAmount;

    @ApiModelProperty(name = "followCarAmount",value = "随车金额",notes = "随车金额")
    private BigDecimal followCarAmount;

    @ApiModelProperty(name = "examineCircularAmount",value = "考核扣款金额",notes = "考核扣款金额")
    private BigDecimal examineCircularAmount;

    @ApiModelProperty(name = "totalAmount",value = "合计金额",notes = "合计金额")
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "thisPeriodHandleAmount",value = "本期处理费用",notes = "本期处理费用")
    private BigDecimal thisPeriodHandleAmount;

    @ApiModelProperty(name = "inProcessExpenseTotal",value = "事中费用合计",notes = "事中费用合计")
    private BigDecimal inProcessExpenseTotal;

    @ApiModelProperty(name = "otherCheckItem",value = "其他核对项",notes = "其他核对项")
    private BigDecimal otherCheckItem;

    @ApiModelProperty(name = "beginPeriodDiscountPoolBalance",value = "期初折扣池余额",notes = "期初折扣池余额")
    private BigDecimal beginPeriodDiscountPoolBalance;

    @ApiModelProperty(name = "thisMonthShouldHandleAmount",value = "本月应处理费用",notes = "本月应处理费用")
    private BigDecimal thisMonthShouldHandleAmount;

    @ApiModelProperty(name = "thisMonthActualDiscountAmount",value = "本月实际折扣金额",notes = "本月实际折扣金额")
    private BigDecimal thisMonthActualDiscountAmount;

    @ApiModelProperty(name = "thisMonthInvoiceReimburseAmount",value = "本月发票报销金额",notes = "本月发票报销金额")
    private BigDecimal thisMonthInvoiceReimburseAmount;

    @ApiModelProperty(name = "endPeriodFeePoolBalance",value = "期末费用池余额",notes = "期末费用池余额")
    private BigDecimal endPeriodFeePoolBalance;

    @ApiModelProperty(name = "costTransfer",value = "费用转移",notes = "费用转移")
    private BigDecimal costTransfer;

    @ApiModelProperty(name = "beginPeriodBalance",value = "期初余额",notes = "期初余额")
    private BigDecimal beginPeriodBalance;

    @ApiModelProperty(name = "thisPeriodBackMoney",value = "本期回款",notes = "本期回款")
    private BigDecimal thisPeriodBackMoney;

    @ApiModelProperty(name = "expenseReimburseUpAccount",value = "费用报销上账",notes = "费用报销上账")
    private BigDecimal expenseReimburseUpAccount;

    @ApiModelProperty(name = "thisPeriodStockInAmount",value = "本期进货金额",notes = "本期进货金额")
    private BigDecimal thisPeriodStockInAmount;

    @ApiModelProperty(name = "thisPeriodSalesDiscount",value = "本期销售折扣",notes = "本期销售折扣")
    private BigDecimal thisPeriodSalesDiscount;

    @ApiModelProperty(name = "endPeriodBalance",value = "期末余额",notes = "期末余额")
    private BigDecimal endPeriodBalance;

    @ApiModelProperty(name = "earnestMoney",value = "保证金金额",notes = "保证金金额")
    private BigDecimal earnestMoney;

}
