/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationGenerateAsyncService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationPdfService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.ReconciliationUtils;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationAsyncResult;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationGenerateAsyncServiceImpl
implements ReconciliationGenerateAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationGenerateAsyncServiceImpl.class);
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ReconciliationPdfService reconciliationPdfService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Async(value="reconciliationAsyncThread")
    public Future<ReconciliationAsyncResult> cal(String customerCode, String type, Date docStartTime, Date docEndTime, ReconciliationGenerateDto generateDto, UserIdentity loginUser, AbstractReconciliationGenerateStrategy abstractReconciliationGenerateStrategy, Map<String, List<TerminalVo>> terminalMap, Map<String, List<CustomerVo>> customerMap, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode{}", (Object)customerCode);
        ReconciliationAsyncResult result = new ReconciliationAsyncResult();
        try {
            ReconciliationDocListVo reconciliationDocListVo;
            this.loginUserService.refreshAuthentication((Object)loginUser);
            if (StringUtils.isEmpty((CharSequence)customerCode)) {
                log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode===>\u4e3a\u7a7a");
                return AsyncResult.forValue((Object)result);
            }
            CustomerVo customerVo = null;
            ReconciliationSummaryDataDisplayDto displayDto = new ReconciliationSummaryDataDisplayDto();
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)type)) {
                SalesOrgSubComOrgVo salesOrgSubComOrgVo;
                if (CollectionUtil.isNotEmpty((Collection)terminalMap.get(customerCode)) && (salesOrgSubComOrgVo = salesOrgSubComOrgVoMap.get((customerVo = customerMap.get(customerCode).get(0)).getSalesInstitutionErpCode())) != null) {
                    displayDto.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                    displayDto.setOrgName(salesOrgSubComOrgVo.getOrgName());
                }
            } else if (CollectionUtil.isNotEmpty((Collection)customerMap.get(customerCode))) {
                customerVo = customerMap.get(customerCode).get(0);
            }
            if (Objects.nonNull(customerVo)) {
                displayDto.setChannelCode(customerVo.getChannel());
                displayDto.setSalesInstitutionCode(customerVo.getSalesInstitutionCode());
                displayDto.setSalesInstitutionErpCode(customerVo.getSalesInstitutionErpCode());
                displayDto.setSalesInstitutionName(customerVo.getSalesInstitutionName());
                displayDto.setSalesRegionCode(customerVo.getSalesRegionCode());
                displayDto.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
                displayDto.setSalesRegionName(customerVo.getSalesRegionName());
                displayDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                displayDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                displayDto.setSalesOrgName(customerVo.getSalesOrgName());
                displayDto.setCustomerCode(customerVo.getErpCode());
                displayDto.setCustomerName(customerVo.getCustomerName());
            }
            if (Objects.isNull((Object)(reconciliationDocListVo = ReconciliationUtils.buildReconciliationVo(generateDto, customerMap, customerCode, docStartTime, docEndTime, terminalMap, type, salesOrgSubComOrgVoMap)))) {
                log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode{}reconciliationDocListVo(customerMap)===>\u4e3a\u7a7a", (Object)customerCode);
                return AsyncResult.forValue((Object)result);
            }
            reconciliationDocListVo.setAccountReconciliationType(abstractReconciliationGenerateStrategy.getReconciliationType());
            List codeList = this.generateCodeService.generateCode("DZ", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS);
            reconciliationDocListVo.setStatementCode((String)codeList.get(0));
            log.info("customerCode{}\u5bf9\u8d26\u5355\u5f00\u59cb\u67e5\u8be2\u6570\u636e", (Object)customerCode);
            List<Object> itemVos = abstractReconciliationGenerateStrategy.findDateList(generateDto, customerCode);
            if (CollectionUtils.isEmpty(itemVos)) {
                log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode:{}\uff0citemVos===>\u4e3a\u7a7a", (Object)customerCode);
                return AsyncResult.forValue((Object)result);
            }
            displayDto.setBusinessUnitCode(generateDto.getBusinessUnitCode());
            displayDto.setBusinessFormatCode(generateDto.getBusinessFormatCode());
            displayDto.setReconciliationType(abstractReconciliationGenerateStrategy.getReconciliationType());
            displayDto.setStatementCode(reconciliationDocListVo.getStatementCode());
            displayDto.setTenantCode(TenantUtils.getTenantCode());
            displayDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            displayDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode{}\uff0c\u5f00\u59cb\u751f\u6210pdf", (Object)customerCode);
            this.reconciliationPdfService.generatePdf(reconciliationDocListVo, itemVos, abstractReconciliationGenerateStrategy, displayDto);
            log.info("\u751f\u6210\u5bf9\u8d26\u5355customerCode{}\uff0c\u751f\u6210pdf\u7ed3\u675f", (Object)customerCode);
            log.info("\u5bf9\u8d26\u5355\u5e74\u6708{}", (Object)reconciliationDocListVo.getReconciliationMonth());
            displayDto.setReconciliationYearMonth(DateUtil.format((Date)reconciliationDocListVo.getReconciliationMonth(), (DatePrinter)DatePattern.NORM_MONTH_FORMAT));
            result.setDisplayDto(displayDto);
            log.info("\u5f00\u59cb\u6784\u5efa\u5173\u8054\u8868");
            ArrayList<ReconciliationCorrelationVo> voList = new ArrayList<ReconciliationCorrelationVo>(itemVos.size());
            itemVos.forEach(item -> {
                if (item == null) {
                    return;
                }
                ReconciliationCorrelationVo reconciliationCorrelationVo = new ReconciliationCorrelationVo();
                reconciliationCorrelationVo.setStatementCode(reconciliationDocListVo.getStatementCode());
                reconciliationCorrelationVo.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
                reconciliationCorrelationVo.setBusinessType(abstractReconciliationGenerateStrategy.getBusinessType());
                try {
                    Optional<Field> activityNameFirst;
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Class<?> aClass = item.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                        fields.addAll(Arrays.asList(aClass.getDeclaredFields()));
                    }
                    Optional<Field> first = fields.stream().filter(x -> x.getName().equals("id")).findFirst();
                    if (first.isPresent()) {
                        Field field = first.get();
                        field.setAccessible(true);
                        reconciliationCorrelationVo.setAssociativeDate(String.valueOf(field.get(item)));
                    }
                    if ((activityNameFirst = fields.stream().filter(x -> x.getName().equals("activityName")).findFirst()).isPresent()) {
                        Field field = activityNameFirst.get();
                        field.setAccessible(true);
                        log.info("\u751f\u6210\u5bf9\u8d26\u5355\u6d3b\u52a8\u540d\u79f0 activityName:{}", field.get(item));
                        reconciliationDocListVo.setActivityName(String.valueOf(field.get(item)));
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("\u5bf9\u8d26\u5355\u8f6c\u6362\u5173\u8054\u8868\u5355,\u5c5e\u6027\u8f6c\u6362\u9519\u8bef", e);
                }
                voList.add(reconciliationCorrelationVo);
            });
            reconciliationDocListVo.setCorrelations(voList);
            result.setReconciliationDocListVo(reconciliationDocListVo);
            log.info("\u7ed3\u675f\u6784\u5efa\u5173\u8054\u8868");
        }
        catch (NullPointerException npe) {
            log.info("\u8fdb\u5165\u7a7a\u6307\u9488\u5f02\u5e38\u5904\u7406");
            log.error("", (Throwable)npe);
            result.setExceptionMsg("\u5ba2\u6237[" + customerCode + "]\u7a7a\u6307\u9488\u5f02\u5e38");
        }
        catch (Exception e) {
            log.info("\u8fdb\u5165\u5176\u4ed6\u5f02\u5e38\u5904\u7406");
            log.error("", (Throwable)e);
            result.setExceptionMsg(e.getMessage());
        }
        return AsyncResult.forValue((Object)result);
    }
}

