/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationGenerateAsyncService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationSummaryDataDisplayService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationAsyncResult;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractReconciliationGenerateStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractReconciliationGenerateStrategy.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ReconciliationSummaryDataDisplayService reconciliationSummaryDataDisplayService;
    @Autowired(required=false)
    private ReconciliationGenerateAsyncService reconciliationGenerateAsyncService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    public abstract String getReconciliationType();

    public abstract String getBusinessType();

    /*
     * WARNING - void declaration
     */
    public List<ReconciliationDocListVo> generateDate(ReconciliationGenerateDto dto) {
        void var17_22;
        List baseByCustomerCodes;
        if (Objects.isNull(dto)) {
            log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            return Collections.emptyList();
        }
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u4fe1\u606f {}    <=====", (Object)JSONObject.toJSONString((Object)dto));
        Date docStartTime = dto.getStartDateTime();
        Date docEndTime = dto.getEndDateTime();
        ArrayList<ReconciliationDocListVo> resultList = new ArrayList<ReconciliationDocListVo>();
        try {
            DateTime startDate = DateUtil.parseDateTime((CharSequence)dto.getStartDate());
            DateTime endDate = DateUtil.parseDateTime((CharSequence)dto.getEndDate());
            dto.setStartDateTime((Date)startDate);
            dto.setEndDateTime((Date)endDate);
        }
        catch (Exception e2) {
            log.error("", (Throwable)e2);
            log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u4fe1\u606f\u65f6,\u65f6\u95f4\u8f6c\u6362\u9519\u8bef {}    <=====", (Object)JSONObject.toJSONString((Object)dto));
        }
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f start {}    <=====", (Object)JSONObject.toJSONString((Object)dto));
        Map<String, Set<String>> customerCodeMap = this.findCustomerCodes(dto);
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f end {}     <=====", customerCodeMap);
        Set<Object> customerCodes = new HashSet();
        String type = null;
        for (Map.Entry<String, Set<String>> entry : customerCodeMap.entrySet()) {
            type = entry.getKey();
            customerCodes = entry.getValue();
        }
        if (CollectionUtils.isEmpty(customerCodes)) {
            log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u65f6,\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u65f6,\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            return Collections.emptyList();
        }
        customerCodes = customerCodes.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u5171[{}]\u4e2a\u5ba2\u6237    <=====", (Object)customerCodes.size());
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u8be6\u7ec6\u5ba2\u6237\u4fe1\u606f{}    <=====", customerCodes);
        if (CollectionUtils.isEmpty(customerCodes)) {
            log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u65f6,\u5ba2\u6237\u4fe1\u606f\u8fc7\u6ee4\u7a7a\u540e\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\u65f6,\u5ba2\u6237\u4fe1\u606f\u8fc7\u6ee4\u7a7a\u540e\u4e3a\u7a7a!\u6267\u884c\u8df3\u8fc7!    <=====");
            return Collections.emptyList();
        }
        int size = customerCodes.size();
        ArrayList terminalVos = new ArrayList();
        HashMap<String, List<TerminalVo>> terminalMap = new HashMap<String, List<TerminalVo>>(size);
        HashMap<String, List<CustomerVo>> customerMap = new HashMap(size);
        Map<String, Object> salesOrgSubComOrgVoMap = new HashMap<String, SalesOrgSubComOrgVo>();
        log.info("\u751f\u6210\u5bf9\u8d26\u5355\u7c7b\u578b:type:{}", (Object)type);
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(type)) {
            baseByCustomerCodes = this.customerVoService.findForSubReconciliation((List)Lists.newArrayList(customerCodes));
            if (CollectionUtils.isEmpty((Collection)baseByCustomerCodes)) {
                log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u4e1a\u52a1\u5355\u5143\u4e3a\u5206\u5b50\u65f6,\u67e5\u8be2\u5ba2\u6237\u7ba1\u7406\uff0c\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!    <=====");
                log.error("=====>    \u8be6\u7ec6\u5ba2\u6237\u4fe1\u606f:{}    <=====", customerCodes);
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u5ba2\u6237\u4fe1\u606f");
            }
            customerMap = baseByCustomerCodes.stream().collect(Collectors.groupingBy(e -> e.getErpCode() + "-" + e.getSalesInstitutionErpCode()));
            List salesInstitutionErpCodes = baseByCustomerCodes.stream().map(CustomerVo::getSalesInstitutionErpCode).distinct().collect(Collectors.toList());
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\u5ba2\u6237\u4fe1\u606f:baseByCustomerCodes:{}", (Object)JsonUtils.obj2JsonString((Object)baseByCustomerCodes));
            if (!CollectionUtils.isEmpty(salesInstitutionErpCodes)) {
                log.info("\u751f\u6210\u5bf9\u8d26\u5355\u9500\u552e\u673a\u6784\u4fe1\u606f:salesInstitutionErpCodes:{}", (Object)JsonUtils.obj2JsonString(salesInstitutionErpCodes));
                List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCodes(salesInstitutionErpCodes);
                log.info("\u751f\u6210\u5bf9\u8d26\u5355\u5206\u5b50\u516c\u53f8hr\u7ec4\u7ec7\u548c\u9500\u552e\u7ec4\u7ec7\u5173\u7cfb:salesOrgSubComOrgVos:{}", (Object)JsonUtils.obj2JsonString((Object)salesOrgSubComOrgVos));
                if (!CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
                    salesOrgSubComOrgVoMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, Function.identity()));
                }
            }
        } else {
            baseByCustomerCodes = this.customerVoService.findCustomerAndContactByCustomerCodes((List)Lists.newArrayList(customerCodes));
            if (CollectionUtils.isEmpty((Collection)baseByCustomerCodes)) {
                log.error("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1a\u4e1a\u52a1\u5355\u5143\u4e3a\u975e\u5206\u5b50\u65f6,\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!    <=====");
                log.error("=====>    \u8be6\u7ec6\u5ba2\u6237\u4fe1\u606f:{}    <=====", customerCodes);
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u5ba2\u6237\u4fe1\u606f");
            }
            customerMap = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getCustomerCode));
        }
        ArrayList<ReconciliationSummaryDataDisplayDto> displayDtos = new ArrayList<ReconciliationSummaryDataDisplayDto>();
        ArrayList<Future<ReconciliationAsyncResult>> futureList = new ArrayList<Future<ReconciliationAsyncResult>>();
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        for (String string : customerCodes) {
            Future<ReconciliationAsyncResult> future = this.reconciliationGenerateAsyncService.cal(string, type, docStartTime, docEndTime, dto, loginUser, this, terminalMap, customerMap, salesOrgSubComOrgVoMap);
            futureList.add(future);
        }
        log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1afutureList\uff1a{}    <=====", (Object)futureList.size());
        ArrayList<Future<ReconciliationAsyncResult>> runningList = new ArrayList<Future<ReconciliationAsyncResult>>();
        int n = 7200;
        while (var17_22 > 0) {
            this.loopFuture(futureList, runningList, displayDtos, resultList);
            log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1aresultList\uff1a{}    <=====", (Object)resultList.size());
            if (CollectionUtils.isEmpty(runningList)) {
                log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1aresultList\uff1a0    <=====");
                break;
            }
            log.info("=====>    \u751f\u6210\u5bf9\u8d26\u5355\uff1arunningList\uff1a{}    <=====", (Object)runningList.size());
            futureList = new ArrayList<Future<ReconciliationAsyncResult>>(runningList);
            runningList.clear();
            --var17_22;
            Thread.sleep(1000L);
        }
        this.reconciliationSummaryDataDisplayService.batchCreate(displayDtos);
        log.info("=====>    \u5bf9\u8d26\u5355\u751f\u6210\u7ed3\u675f    <=====");
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loopFuture(List<Future<ReconciliationAsyncResult>> futureList, List<Future<ReconciliationAsyncResult>> runningList, List<ReconciliationSummaryDataDisplayDto> displayDtos, List<ReconciliationDocListVo> resultList) {
        for (Future<ReconciliationAsyncResult> future : futureList) {
            if (!future.isDone()) {
                runningList.add(future);
                continue;
            }
            try {
                ReconciliationAsyncResult result = future.get();
                if (!StringUtils.isEmpty((CharSequence)result.getExceptionMsg())) {
                    throw new IllegalArgumentException(result.getExceptionMsg());
                }
                if (Objects.nonNull((Object)result.getDisplayDto())) {
                    displayDtos.add(result.getDisplayDto());
                }
                if (!Objects.nonNull((Object)result.getReconciliationDocListVo())) continue;
                resultList.add(result.getReconciliationDocListVo());
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5bf9\u8d26\u5355\uff1a" + e.getMessage());
                log.error("", (Throwable)e);
                throw new RuntimeException("\u751f\u6210\u5bf9\u8d26\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                return;
            }
        }
    }

    public abstract Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto var1);

    public abstract List<T> findDateList(ReconciliationGenerateDto var1, String var2);

    public abstract String convert(String var1, T var2);

    public abstract String convertHead(String var1, List<Object> var2);

    public abstract void convertTail(LinkedHashMap<String, String> var1);
}

