/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconciliationUtils {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationUtils.class);

    public static ReconciliationDocListVo buildReconciliationVo(ReconciliationGenerateDto reconciliationGenerateDto, Map<String, List<CustomerVo>> customerMap, String customerCode, Date startTime, Date endTime, Map<String, List<TerminalVo>> terminalMap, String type, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        ReconciliationDocListVo reconciliationDocListVo = new ReconciliationDocListVo();
        reconciliationDocListVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationDocListVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        reconciliationDocListVo.setTenantCode(TenantUtils.getTenantCode());
        reconciliationDocListVo.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        reconciliationDocListVo.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        reconciliationDocListVo.setStartDate(startTime);
        reconciliationDocListVo.setEndDate(endTime);
        reconciliationDocListVo.setStatementStatus(ReconciliationStatusEnum.WAIT.getCode());
        reconciliationDocListVo.setAccountReconciliationRuleCode(reconciliationGenerateDto.getAccountReconciliationRuleCode());
        reconciliationDocListVo.setReconciliationMonth(reconciliationGenerateDto.getStartDateTime());
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(type)) {
            if (CollectionUtils.isEmpty((Collection)customerMap.get(customerCode))) {
                return null;
            }
            CustomerVo customer = customerMap.get(customerCode).get(0);
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\u5ba2\u6237\u4fe1\u606f:customer:{}", (Object)JsonUtils.obj2JsonString((Object)customer));
            SalesOrgSubComOrgVo salesOrgSubComOrgVo = salesOrgSubComOrgVoMap.get(customer.getSalesInstitutionErpCode());
            log.info("\u751f\u6210\u5bf9\u8d26\u5355hr\u7ec4\u7ec7\u548c\u9500\u552e\u7ec4\u7ec7\u5173\u7cfb:salesOrgSubComOrgVo:{}", (Object)JsonUtils.obj2JsonString((Object)salesOrgSubComOrgVo));
            if (salesOrgSubComOrgVo != null) {
                reconciliationDocListVo.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                reconciliationDocListVo.setOrgName(salesOrgSubComOrgVo.getOrgName());
            }
            reconciliationDocListVo.setCustomerName(customer.getCustomerName());
            reconciliationDocListVo.setCustomerCode(customer.getErpCode());
            reconciliationDocListVo.setCustomerErpCode(customer.getErpCode());
            reconciliationDocListVo.setSalesOrgName(customer.getSalesRegionName());
            reconciliationDocListVo.setSalesOrgCode(customer.getSalesRegionCode());
            reconciliationDocListVo.setSalesGroupName(customer.getSalesOrgName());
            reconciliationDocListVo.setSalesGroupCode(customer.getSalesOrgCode());
            reconciliationDocListVo.setSalesInstitutionName(customer.getSalesInstitutionName());
            reconciliationDocListVo.setSalesInstitutionCode(customer.getSalesInstitutionCode());
            reconciliationDocListVo.setSalesInstitutionErpCode(customer.getSalesInstitutionErpCode());
            reconciliationDocListVo.setCustomerChannelCode(customer.getCustomerChannelCode());
            reconciliationDocListVo.setCustomerBusinessFormatCode(customer.getBusinessFormatCode());
            reconciliationDocListVo.setRecipientName(customer.getReconReceiveName());
            reconciliationDocListVo.setReceiverTelephone(customer.getReconReceivePhone());
            reconciliationDocListVo.setRecipientEmail(customer.getReconReceiveEmail());
        } else {
            if (CollectionUtils.isEmpty((Collection)customerMap.get(customerCode))) {
                return null;
            }
            CustomerVo customer = customerMap.get(customerCode).get(0);
            reconciliationDocListVo.setCustomerName(customer.getCustomerName());
            reconciliationDocListVo.setCustomerCode(customerCode);
            reconciliationDocListVo.setCustomerErpCode(customer.getErpCode());
            reconciliationDocListVo.setSalesOrgName(customer.getSalesRegionName());
            reconciliationDocListVo.setSalesOrgCode(customer.getSalesRegionCode());
            reconciliationDocListVo.setSalesGroupName(customer.getSalesOrgName());
            reconciliationDocListVo.setSalesGroupCode(customer.getSalesOrgCode());
            reconciliationDocListVo.setSalesInstitutionName(customer.getSalesInstitutionName());
            reconciliationDocListVo.setSalesInstitutionCode(customer.getSalesInstitutionCode());
            reconciliationDocListVo.setSalesInstitutionErpCode(customer.getSalesInstitutionErpCode());
            reconciliationDocListVo.setRecipientName(customer.getReconReceiveName());
            reconciliationDocListVo.setReceiverTelephone(customer.getReconReceivePhone());
            reconciliationDocListVo.setRecipientEmail(customer.getReconReceiveEmail());
        }
        return reconciliationDocListVo;
    }
}

