/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.red.pay.ledger.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.red.pay.ledger.local.entity.MemberRedPacket;
import com.biz.crm.tpm.business.red.pay.ledger.local.entity.RedPayLedger;
import com.biz.crm.tpm.business.red.pay.ledger.local.repository.MemberRedPacketRepository;
import com.biz.crm.tpm.business.red.pay.ledger.local.repository.RedPayLedgerRepository;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.MemberRedPacketDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayLedgerDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayLedgerLogEventDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayWithdrawalDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.event.RedPayLedgerEventListener;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.event.log.RedPayLedgerLogEventListener;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.service.RedPayLedgerVoService;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.MemberRedPacketVo;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.RedPayLedgerLogVo;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.RedPayLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="redPayLedgerService")
public class RedPayLedgerVoServiceImpl
implements RedPayLedgerVoService {
    private static final Logger log = LoggerFactory.getLogger(RedPayLedgerVoServiceImpl.class);
    @Autowired(required=false)
    private RedPayLedgerRepository redPayLedgerRepository;
    @Autowired(required=false)
    private List<RedPayLedgerEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MemberRedPacketRepository memberRedPacketRepository;
    @Autowired(required=false)
    private EventPrepaymentService eventPrepaymentService;
    @Autowired(required=false)
    private AuditService auditService;

    public Page<RedPayLedgerVo> findByConditions(Pageable pageable, RedPayLedgerDto dto) {
        Page<RedPayLedgerVo> page2 = this.redPayLedgerRepository.findByConditions(pageable, dto);
        page2.setRecords(this.fillData(page2));
        return page2;
    }

    private List<RedPayLedgerVo> fillData(Page<RedPayLedgerVo> page2) {
        List records = page2.getRecords();
        List detailPlanItemCodes = records.stream().map(RedPayLedgerVo::getDetailPlanItemCode).collect(Collectors.toList());
        List customerPrepaymentVos = this.eventPrepaymentService.findActivityPrepaymentByDetailPlanItemCodes(detailPlanItemCodes);
        Map<Object, Object> customerPrepaymentVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerPrepaymentVos)) {
            customerPrepaymentVoMap = customerPrepaymentVos.stream().collect(Collectors.groupingBy(CustomerPrepaymentVo::getActivityDetailItemCode));
        }
        List auditCustomerDetailVos = this.auditService.findListByDetailPlanCodes(detailPlanItemCodes);
        log.info("\u7ea2\u5305\u5145\u503c\u53f0\u8d26\u67e5\u8be2\u7ed3\u6848\u6838\u9500\u6570\u636e\uff1aauditCustomerDetailVos:{}", (Object)JsonUtils.obj2JsonString((Object)auditCustomerDetailVos));
        Map<Object, Object> auditCustomerDetailVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)auditCustomerDetailVos)) {
            List auditCustomerDetailVos1 = auditCustomerDetailVos.stream().filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode()) && UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(o.getReimburseUpAccountStatus())).collect(Collectors.toList());
            List auditCustomerDetailVos2 = auditCustomerDetailVos.stream().filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode()) && UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(o.getDiscountUpAccountStatus())).collect(Collectors.toList());
            ArrayList auditCustomerDetailVoAll = new ArrayList();
            auditCustomerDetailVoAll.addAll(auditCustomerDetailVos1);
            auditCustomerDetailVoAll.addAll(auditCustomerDetailVos2);
            log.info("\u7ea2\u5305\u5145\u503c\u53f0\u8d26\u67e5\u8be2\u7ed3\u6848\u6838\u9500\u6570\u636e2\uff1aauditCustomerDetailVoAll:{}", (Object)JsonUtils.obj2JsonString(auditCustomerDetailVoAll));
            auditCustomerDetailVoMap = auditCustomerDetailVoAll.stream().collect(Collectors.groupingBy(AuditCustomerDetailVo::getActivityDetailCode));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (RedPayLedgerVo vo : records) {
            List auditCustomerDetailList;
            List customerPrepaymentList = (List)customerPrepaymentVoMap.get(vo.getDetailPlanItemCode());
            if (CollectionUtils.isNotEmpty((Collection)customerPrepaymentList)) {
                vo.setReturnDocCode(customerPrepaymentList.stream().map(CustomerPrepaymentVo::getReturnDocCode).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",")));
                vo.setPrepaidCoding(customerPrepaymentList.stream().map(CustomerPrepaymentVo::getPrepaidCoding).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",")));
                vo.setPrepaymentDate(customerPrepaymentList.stream().map(CustomerPrepaymentVo::getPrepaymentDate).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",")));
                vo.setTotalPrepayAmount(customerPrepaymentList.stream().map(CustomerPrepaymentVo::getPrepaidAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(auditCustomerDetailList = (List)auditCustomerDetailVoMap.get(vo.getDetailPlanItemCode())))) continue;
            log.info("\u7ea2\u5305\u5145\u503c\u53f0\u8d26\u67e5\u8be2\u7ed3\u6848\u6838\u9500\u6570\u636e3\uff1aauditCustomerDetailList:{}", (Object)JsonUtils.obj2JsonString((Object)auditCustomerDetailList));
            vo.setAuditCreateTime(auditCustomerDetailList.stream().map(AuditCustomerDetailVo::getAuditCreateTime).filter(Objects::nonNull).distinct().map(df::format).collect(Collectors.joining(",")));
            vo.setAuditCode(auditCustomerDetailList.stream().map(AuditCustomerDetailVo::getAuditCode).distinct().collect(Collectors.joining(",")));
            vo.setProcessDate(auditCustomerDetailList.stream().map(AuditCustomerDetailVo::getProcessDate).filter(Objects::nonNull).distinct().map(df::format).collect(Collectors.joining(",")));
            vo.setThisAuditAmount(auditCustomerDetailList.stream().map(AuditCustomerDetailVo::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            vo.setIncomeTaxPay(Optional.ofNullable(vo.getThisAuditAmount()).orElse(BigDecimal.ZERO).divide(new BigDecimal("0.8"), 6, RoundingMode.HALF_UP).multiply(new BigDecimal("0.2")));
            vo.setBookedAmount(Optional.ofNullable(vo.getThisAuditAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(vo.getIncomeTaxPay()).orElse(BigDecimal.ZERO)));
            if (Optional.ofNullable(vo.getTotalPrepayAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 0) {
                vo.setBalance(BigDecimal.ZERO);
                continue;
            }
            vo.setBalance(Optional.ofNullable(vo.getTotalPrepayAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(vo.getThisAuditAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(vo.getWithdrawalAmount()).orElse(BigDecimal.ZERO)));
        }
        return records;
    }

    public RedPayLedgerVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RedPayLedger redPayLedger = this.redPayLedgerRepository.findById(id);
        if (redPayLedger == null) {
            return null;
        }
        return (RedPayLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPayLedger, RedPayLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public RedPayLedgerVo create(RedPayLedgerVo redPayLedgerVo) {
        this.createValidation(redPayLedgerVo);
        redPayLedgerVo.setTenantCode(TenantUtils.getTenantCode());
        redPayLedgerVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        redPayLedgerVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        RedPayLedger redPayLedger = (RedPayLedger)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPayLedgerVo, RedPayLedger.class, HashSet.class, ArrayList.class, new String[0]));
        this.redPayLedgerRepository.saveOrUpdate((Object)redPayLedger);
        redPayLedgerVo.setId(redPayLedger.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (RedPayLedgerEventListener redPayLedgerEventListener : this.eventListeners) {
                redPayLedgerEventListener.onCreate(redPayLedgerVo);
            }
        }
        RedPayLedgerLogEventDto logEventDto = new RedPayLedgerLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(redPayLedgerVo);
        SerializableBiConsumer & Serializable onCreate = RedPayLedgerLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, RedPayLedgerLogEventListener.class, (SerializableBiConsumer)onCreate);
        return redPayLedgerVo;
    }

    @Transactional
    public RedPayLedgerVo update(RedPayLedgerVo redPayLedgerVo) {
        this.updateValidation(redPayLedgerVo);
        String currentId = redPayLedgerVo.getId();
        RedPayLedger current = this.redPayLedgerRepository.findById(currentId);
        current = (RedPayLedger)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        RedPayLedgerVo oldVo = (RedPayLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, RedPayLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.redPayLedgerRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (RedPayLedgerEventListener redPayLedgerEventListener : this.eventListeners) {
                redPayLedgerEventListener.onUpdate(oldVo, redPayLedgerVo);
            }
        }
        RedPayLedgerLogEventDto logEventDto = new RedPayLedgerLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(redPayLedgerVo);
        SerializableBiConsumer & Serializable onUpdate = RedPayLedgerLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, RedPayLedgerLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return redPayLedgerVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redPayLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redPayLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redPayLedgerRepository.updateDelFlagByIds(ids);
    }

    public RedPayWithdrawalDto calculateAmount(List<String> ids) {
        Validate.notNull(ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<RedPayLedger> redPayLedgers = this.redPayLedgerRepository.findByIds(ids);
        Validate.notNull(redPayLedgers, (String)"\u5bf9\u5e94\u7684\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728!!!", (Object[])new Object[0]);
        RedPayWithdrawalDto redPayWithdrawalDto = new RedPayWithdrawalDto();
        redPayWithdrawalDto.setIds(ids);
        return redPayWithdrawalDto;
    }

    public void saveBatchMemberRedPacket(List<MemberRedPacketDto> memberRedPacketDtos) {
        if (CollectionUtils.isNotEmpty(memberRedPacketDtos)) {
            Set planItemCodeSet = memberRedPacketDtos.stream().map(MemberRedPacketDto::getPlanItemCode).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(planItemCodeSet)) {
                this.memberRedPacketRepository.remove((Wrapper)Wrappers.lambdaUpdate(MemberRedPacket.class).in(MemberRedPacket::getPlanItemCode, planItemCodeSet));
            }
            HashMap memberRedPacketMap = new HashMap();
            Collection memberRedPackets = this.nebulaToolkitService.copyCollectionByBlankList(memberRedPacketDtos, MemberRedPacketDto.class, MemberRedPacket.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            memberRedPackets.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.memberRedPacketRepository.saveOrUpdateBatch(memberRedPackets);
        }
    }

    public List<MemberRedPacketVo> findByPlanItemCode(MemberRedPacketDto memberRedPacketDto) {
        if (Objects.isNull(memberRedPacketDto)) {
            return null;
        }
        List memberRedPackets = ((LambdaQueryChainWrapper)this.memberRedPacketRepository.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)memberRedPacketDto.getPlanItemCode()), MemberRedPacket::getPlanItemCode, (Object)memberRedPacketDto.getPlanItemCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)memberRedPackets)) {
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)memberRedPackets, MemberRedPacket.class, MemberRedPacketVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        }
        return new ArrayList<MemberRedPacketVo>();
    }

    public void createBatch(List<RedPayLedgerDto> dtos) {
        if (CollectionUtils.isNotEmpty(dtos)) {
            dtos.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection redPayLedgers = this.nebulaToolkitService.copyCollectionByWhiteList(dtos, RedPayLedgerDto.class, RedPayLedger.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.redPayLedgerRepository.saveBatch(redPayLedgers);
        }
    }

    public void withdrawDeposit(RedPayLedgerDto dto) {
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSharedOrderCode(), (String)"\u5171\u4eab\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithdrawalTime(), (String)"\u63d0\u73b0\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getWithdrawalAmount(), (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedPayLedger redPayLedger = new RedPayLedger();
        redPayLedger.setId(dto.getId());
        redPayLedger.setSharedOrderCode(dto.getSharedOrderCode());
        redPayLedger.setWithdrawalAmount(dto.getWithdrawalAmount());
        redPayLedger.setWithdrawalTime(dto.getWithdrawalTime());
        redPayLedger.setInterfaceFlag(YesOrNoEnum.NO.getCode());
        this.redPayLedgerRepository.updateById((Object)redPayLedger);
    }

    public RedPayLedgerLogVo log(String id) {
        List auditProcessDate;
        List prepaymentProcessDate;
        Validate.notBlank((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RedPayLedger redPayLedger = (RedPayLedger)((Object)this.redPayLedgerRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)redPayLedger), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        RedPayLedgerLogVo redPayLedgerLogVo = new RedPayLedgerLogVo();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        redPayLedgerLogVo.setPlanDetailPassTime(df.format(redPayLedger.getCreateTime()));
        if (Objects.nonNull(redPayLedger.getMiddlegroundTime())) {
            redPayLedgerLogVo.setMiddlegroundTime(df.format(redPayLedger.getMiddlegroundTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(prepaymentProcessDate = this.eventPrepaymentService.findProcessDateByActivityDetailCodes(redPayLedger.getDetailPlanItemCode())))) {
            redPayLedgerLogVo.setPrepayTime(String.join((CharSequence)",", prepaymentProcessDate));
        }
        if (CollectionUtils.isNotEmpty((Collection)(auditProcessDate = this.auditService.findProcessDateByActivityDetailCodes(redPayLedger.getDetailPlanItemCode())))) {
            redPayLedgerLogVo.setAuditPassTime(String.join((CharSequence)",", auditProcessDate));
        }
        redPayLedgerLogVo.setWithdrawalTime(redPayLedger.getWithdrawalTime());
        return redPayLedgerLogVo;
    }

    public void withdrawal(RedPayWithdrawalDto redPayWithdrawalDto) {
    }

    private void createValidation(RedPayLedgerVo redPayLedgerVo) {
        this.validation(redPayLedgerVo);
    }

    private void updateValidation(RedPayLedgerVo redPayLedgerVo) {
        this.validation(redPayLedgerVo);
    }

    private void validation(RedPayLedgerVo redPayLedgerVo) {
    }
}

