package com.biz.crm.tpm.business.red.pay.ledger.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/30 17:17
 * @description：会员红包
 */
@Data
@ApiModel(value = "MemberRedPacketDto", description = "会员红包")
public class MemberRedPacketDto extends TenantFlagOpDto {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("用户手机号")
    private String userPhone;

    @ApiModelProperty("红包金额")
    private BigDecimal redPacketAmount;

    @ApiModelProperty("所属活动")
    private String belongActivity;

    @ApiModelProperty("时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date theDate;

    @ApiModelProperty("获得方式（提现or领取）")
    private String gainWay;
}
