package com.biz.crm.tpm.business.red.pay.ledger.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * TPM-红包充值帐台dto
 *
 * @author makejava
 * @date 2022-12-17 14:25:23
 */
@Data
@ApiModel(value = "RedPayLedgerDto", description = "TPM-红包充值帐台dto")
public class RedPayLedgerDto extends TenantFlagOpDto {

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    private String planCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    private String detailPlanName;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    @Deprecated
    private String planName;

    /**
     * 方案所属部门
     */
    @ApiModelProperty("方案所属部门编码")
    @Deprecated
    private String planDepartmentCode;

    /**
     * 方案所属部门
     */
    @ApiModelProperty("方案所属部门名称")
    @Deprecated
    private String planDepartmentName;

    /**
     * 方案申请时间
     */
    @ApiModelProperty("方案申请时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Deprecated
    private Date planApplicationDate;


    /**
     * 方案明细编码
     */
    @ApiModelProperty("方案明细编码")
    @Deprecated
    private String planItemCode;


    /**
     * 方案明细申请金额
     */
    @ApiModelProperty("方案明细申请金额")
    @Deprecated
    private BigDecimal planItemApplyAmount;

    @ApiModelProperty("细案归属部门")
    private String departmentCode;

    @ApiModelProperty("细案归属部门")
    private String departmentName;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    private Date activityBeginDateBegin;
    private Date activityBeginDateEnd;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;
    private Date activityEndDateBegin;
    private Date activityEndDateEnd;

    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;

    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    private String monthBudgetCode;

    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;

    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;

    /**
     * ce单据编码
     */
    @ApiModelProperty("ce单据编码")
    private String returnDocCode;

    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding", value = "预付编码", notes = "预付编码")
    private String prepaidCoding;

    @ApiModelProperty(name = "prepaymentDate",value = "预付年月", notes = "预付年月")
    private String prepaymentDate;


    /**
     * 预付金额合计
     */
    @ApiModelProperty(name = "totalPrepayAmount", notes = "预付金额")
    private BigDecimal totalPrepayAmount;

    /**
     * 共享请求单单号
     */
    @ApiModelProperty(name = "sharedOrderCode", value = "共享请求单单号", notes = "共享请求单单号")
    private String sharedOrderCode;

    /**
     * 提现金额
     */
    @ApiModelProperty(name = "withdrawalAmount", notes = "提现金额")
    private BigDecimal withdrawalAmount;

    /**
     * 提现时间
     */
    @ApiModelProperty("提现时间")
    private String withdrawalTime;

    @ApiModelProperty("接口传输标识")
    private String interfaceFlag;

    @ApiModelProperty("数据中台返回数据时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date middlegroundTime;
    private Date middlegroundTimeBegin;
    private Date middlegroundTimeEnd;

    @ApiModelProperty("核销时间")
    private String auditCreateTime;

    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty("上账时间")
    private String processDate;

    @ApiModelProperty(name = "本次结案金额", notes = "本次结案金额")
    private BigDecimal thisAuditAmount;

    /**
     * 入账金额
     */
    @ApiModelProperty(name = "bookedAmount", notes = "入账金额", value = "入账金额")
    private BigDecimal bookedAmount;

    /**
     * 个税缴纳
     */
    @ApiModelProperty(name = "incomeTaxPay", notes = "个税缴纳", value = "个税缴纳")
    private BigDecimal incomeTaxPay;

    /**
     * 余额
     */
    @ApiModelProperty(name = "balance", notes = "余额", value = "余额")
    private BigDecimal balance;
}

