package com.biz.crm.tpm.business.red.pay.ledger.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "RedPayWithdrawalDto", description = "TPM-红包充值帐台提现dto")
public class RedPayWithdrawalDto {

    @ApiModelProperty("勾选的列表id集合")
    private List<String> ids;

    @ApiModelProperty(name = "预付金额", notes = "预付金额")
    private BigDecimal thisPrepayAmount;


    @ApiModelProperty(name = "本次结案金额", notes = "本次结案金额")
    private BigDecimal thisAuditAmount;

    /**
     * 共享请求单单号
     */
    @ApiModelProperty(name = "sharedOrderCode", value = "共享请求单单号", notes = "共享请求单单号")
    private String sharedOrderCode;

    /**
     * 提现金额
     */
    @ApiModelProperty(name = "withdrawalAmount", notes = "提现金额")
    private BigDecimal withdrawalAmount;

    /**
     * 提现时间
     */
    @ApiModelProperty("提现时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date withdrawalTime;

}
