package com.biz.crm.tpm.business.red.pay.ledger.sdk.event;

import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.RedPayLedgerVo;

import java.util.List;

/**
 * TPM-红包充值帐台变更事件通知接口
 *
 * @author makejava
 * @date 2022-12-17 14:25:23
 */
public interface RedPayLedgerEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(RedPayLedgerVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(RedPayLedgerVo oldVo, RedPayLedgerVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<RedPayLedgerVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<RedPayLedgerVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<RedPayLedgerVo> list);
}

