package com.biz.crm.tpm.business.red.pay.ledger.sdk.event.log;

import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayLedgerLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * TPM-红包充值帐台变更事件通知接口
 *
 * @author makejava
 * @date 2022-12-17 14:25:24
 */
public interface RedPayLedgerLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(RedPayLedgerLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(RedPayLedgerLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(RedPayLedgerLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(RedPayLedgerLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(RedPayLedgerLogEventDto eventDto);

}

