package com.biz.crm.tpm.business.red.pay.ledger.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.MemberRedPacketDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayLedgerDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.RedPayWithdrawalDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.MemberRedPacketVo;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.RedPayLedgerLogVo;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.RedPayLedgerVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-红包充值帐台(RedPayLedger)表服务接口
 *
 * @author makejava
 * @date 2022-12-17 14:25:23
 */
public interface RedPayLedgerVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<RedPayLedgerVo> findByConditions(Pageable pageable, RedPayLedgerDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    RedPayLedgerVo findDetailById(String id);

    /**
     * 创建
     *
     * @param redPayLedgerVo
     * @return
     */
    RedPayLedgerVo create(RedPayLedgerVo redPayLedgerVo);

    /**
     * 更新
     *
     * @param redPayLedgerVo
     * @return
     */
    RedPayLedgerVo update(RedPayLedgerVo redPayLedgerVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 提现
     *
     * @param redPayWithdrawalDto 提现请求dto
     */
    void withdrawal(RedPayWithdrawalDto redPayWithdrawalDto);

    /**
     * 计算提现金额
     * @param ids 主键id列表
     * @return 提现dto
     */
    RedPayWithdrawalDto calculateAmount(List<String> ids);

    void saveBatchMemberRedPacket(List<MemberRedPacketDto> memberRedPacketDtos);

    /**
     * 关键指标——红包兑付金额，根据活动编码查询红包充值明细
     * @param memberRedPacketDto
     * @return
     */
    List<MemberRedPacketVo> findByPlanItemCode(MemberRedPacketDto memberRedPacketDto);

    /**
     * 批量创建
     * @param dtos
     */
    void createBatch(List<RedPayLedgerDto> dtos);

    /**
     * 提现
     * @param dto
     */
    void withdrawDeposit(RedPayLedgerDto dto);

    RedPayLedgerLogVo log(String id);

}
