package com.biz.crm.tpm.business.sales.goal.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.sales.goal.feign.feign.impl.SalesGoalFeignImpl;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月17日 16:32
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SalesGoalFeignImpl.class)
public interface SalesGoalFeign {

    /**
     * 条件查询
     *
     * @param salesGoalDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>>
     * @author huojia
     * @date 2022/12/17 16:57
     **/
    @PostMapping("/v1/sales/goal/listByConditions")
    Result<List<SalesGoalVo>> listByConditions(@RequestBody SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计数据的分子公司出库量
     *
     * @param salesGoalDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.math.BigDecimal>
     * @author huojia
     * @date 2022/12/17 17:00
     **/
    @PostMapping("/v1/sales/goal/outStockNumber")
    Result<BigDecimal> outStockNumber(@RequestBody SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计经销商进货量
     *
     * @param salesGoalDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.math.BigDecimal>
     * @author huojia
     * @date 2022/12/17 17:00
     **/
    @PostMapping("/v1/sales/goal/inStockNumber")
    Result<BigDecimal> inStockNumber(@RequestBody SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计销售数量
     *
     * @param salesGoalDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.math.BigDecimal>
     * @author huojia
     * @date 2022/12/17 17:01
     **/
    @PostMapping("/v1/sales/goal/getSaleAmount")
    Result<BigDecimal> getSaleAmount(@RequestBody SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计任务量
     *
     * @param salesGoalDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.math.BigDecimal>
     * @author huojia
     * @date 2022/12/17 17:01
     **/
    @PostMapping("/v1/sales/goal/getTaskAmount")
    Result<BigDecimal> getTaskAmount(@RequestBody SalesGoalDto salesGoalDto);

    /**
     * 分页统计销售目标任务量
     *
     * @param pageable
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo>>
     * @author huojia
     * @date 2022/12/17 17:01
     **/
    @GetMapping("/v1/sales/goal/statistics/findByConditions")
    Result<Page<SalesGoalStatisticsVo>> findByConditions(Pageable pageable, SalesGoalStatisticsDto dto);

    /**
     * 查询按区域分组的数据
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>>
     * @author huojia
     * @date 2022/12/17 17:01
     **/
    @PostMapping("/v1/sales/goal/findListGroupByRegion")
    Result<List<SalesGoalVo>> findListGroupByRegion(@RequestBody SalesGoalDto dto);

    @PostMapping("/v1/sales/goal/findSalesGoal")
    Result<List<SalesGoalVo>> findSalesGoal(@RequestBody SalesGoalDto salesGoal);

    @ApiOperation(value = "指标计算查询")
    @PostMapping("/v1/sales/goal/listForVariableCal")
    Result<List<SalesGoalVo>> listForVariableCal(@RequestBody SalesGoalDto dto);

    @ApiOperation("值汇总")
    @PostMapping("/v1/sales/goal/getSalesGoalAmount")
    Result<BigDecimal> getSalesGoalAmount(@RequestBody SalesGoalDto salesGoal);

    /**
     * 根据业态，业务单元，分组，年月，统计折前销量，按照零售商+区域分组，-隔开
     *
     * @param dto
     * @return Map<String,BigDecimal>
     */
    @ApiOperation(value = "根据业态，业务单元，分组，年月，统计折前销量，按照零售商+区域分组，-隔开")
    @PostMapping("/v1/sales/goal/getSalesBeforeDiscount")
    Result<Map<String,BigDecimal>> getSalesBeforeDiscount(@RequestBody SalesGoalDiscountSalesStatisticsDto dto);

    /**
     * 根据业态，业务单元，分组，年月，统计折后销量，按照零售商+区域分组，-隔开
     *
     * @param dto
     * @return Map<String,BigDecimal>
     */
    @ApiOperation(value = "根据业态，业务单元，分组，年月，统计折后销量，按照零售商+区域分组，-隔开")
    @PostMapping("/v1/sales/goal/getSalesAfterDiscount")
    Result<Map<String,BigDecimal>> getSalesAfterDiscount(@RequestBody SalesGoalDiscountSalesStatisticsDto dto);
}
