package com.biz.crm.tpm.business.sales.goal.feign.feign.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.sales.goal.feign.feign.SalesGoalFeign;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月17日 16:37
 */
@Slf4j
@Component
public class SalesGoalFeignImpl implements FallbackFactory<SalesGoalFeign> {

    @Override
    public SalesGoalFeign create(Throwable throwable) {
        return new SalesGoalFeign() {
            @Override
            public Result<List<SalesGoalVo>> listByConditions(SalesGoalDto salesGoalDto) {
                throw new UnsupportedOperationException("批量查询销售任务熔断");
            }

            @Override
            public Result<BigDecimal> outStockNumber(SalesGoalDto salesGoalDto) {
                throw new UnsupportedOperationException("查询分子公司出库量熔断");
            }

            @Override
            public Result<BigDecimal> inStockNumber(SalesGoalDto salesGoalDto) {
                throw new UnsupportedOperationException("查询经销商进货量熔断");
            }

            @Override
            public Result<BigDecimal> getSaleAmount(SalesGoalDto salesGoalDto) {
                throw new UnsupportedOperationException("查询统计销售数量熔断");
            }

            @Override
            public Result<BigDecimal> getTaskAmount(SalesGoalDto salesGoalDto) {
                throw new UnsupportedOperationException("查询统计任务量熔断");
            }

            @Override
            public Result<Page<SalesGoalStatisticsVo>> findByConditions(Pageable pageable, SalesGoalStatisticsDto dto) {
                throw new UnsupportedOperationException("分页统计销售目标任务量熔断");
            }

            @Override
            public Result<List<SalesGoalVo>> findListGroupByRegion(SalesGoalDto dto) {
                throw new UnsupportedOperationException("查询按区域分组的数据熔断");
            }

            @Override
            public Result<List<SalesGoalVo>> findSalesGoal(SalesGoalDto salesGoal) {

                throw new UnsupportedOperationException("查询销售目标异常");
            }

            @Override
            public Result<List<SalesGoalVo>> listForVariableCal(SalesGoalDto dto) {
                throw new UnsupportedOperationException("指标计算查询销售目标任务量熔断");
            }

            @Override
            public Result<BigDecimal> getSalesGoalAmount(SalesGoalDto salesGoal) {
                throw  new UnsupportedOperationException("取值汇总异常");
            }


            @Override
            public Result<Map<String, BigDecimal>> getSalesBeforeDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
                throw new UnsupportedOperationException("根据业态，业务单元，分组，年月，统计折前销量熔断");
            }

            @Override
            public Result<Map<String, BigDecimal>> getSalesAfterDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
                throw new UnsupportedOperationException("根据业态，业务单元，分组，年月，统计折后销量熔断");
            }
        };
    }
}
