package com.biz.crm.tpm.business.sales.goal.feign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.feign.feign.SalesGoalFeign;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVerticalImportsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月17日 16:31
 */
@Slf4j
@Service
public class SalesGoalServiceImpl implements SalesGoalService {

    @Resource
    private SalesGoalFeign salesGoalFeign;

    @Override
    public Page<SalesGoalVo> findByConditions(Pageable pageable, SalesGoalDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesGoalVo findById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesGoalVo update(SalesGoalDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void importSave(List<SalesGoalDto> importList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesGoalVo> listByConditions(SalesGoalDto salesGoalDto) {
        Result<List<SalesGoalVo>> result = salesGoalFeign.listByConditions(salesGoalDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public BigDecimal getSalesGoalAmount(SalesGoalDto salesGoal) {
        Result<BigDecimal> result = salesGoalFeign.getSalesGoalAmount(salesGoal);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public BigDecimal outStockNumber(SalesGoalDto salesGoalDto) {
        Result<BigDecimal> result = salesGoalFeign.outStockNumber(salesGoalDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public BigDecimal inStockNumber(SalesGoalDto salesGoalDto) {
        Result<BigDecimal> result = salesGoalFeign.inStockNumber(salesGoalDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public BigDecimal getSaleAmount(SalesGoalDto salesGoalDto) {
        Result<BigDecimal> result = salesGoalFeign.getSaleAmount(salesGoalDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public BigDecimal getTaskAmount(SalesGoalDto salesGoalDto) {
        Result<BigDecimal> result = salesGoalFeign.getTaskAmount(salesGoalDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Page<SalesGoalStatisticsVo> findByConditions(Pageable pageable, SalesGoalStatisticsDto dto) {
        Result<Page<SalesGoalStatisticsVo>> result = salesGoalFeign.findByConditions(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<SalesGoalVo> findListGroupByRegion(SalesGoalDto dto) {
        Result<List<SalesGoalVo>> result = salesGoalFeign.findListGroupByRegion(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void pullSalesDayReportAsync(MasterDataMdgBaseDto dto, UserIdentity userIdentity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pullSalesDayReport(MasterDataMdgBaseDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesGoalVo> listVerticalByConditions(SalesGoalDto salesGoalDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesGoalSumVo> listVerticalSumByConditions(SalesGoalDto salesGoalDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesGoalVo> findSalesGoal(SalesGoalDto salesGoal) {

        Result<List<SalesGoalVo>> result = salesGoalFeign.findSalesGoal(salesGoal);

        Assert.isTrue(result.isSuccess(), result.getMessage());

        return result.getResult();
    }

    /**
     * 指标计算查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<SalesGoalVo> listForVariableCal(SalesGoalDto dto) {
        Result<List<SalesGoalVo>> result = salesGoalFeign.listForVariableCal(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<SalesGoalVo> listForVariableCalNew(SalesGoalDto dto) {
        Result<List<SalesGoalVo>> result = salesGoalFeign.listForVariableCal(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 授权预算项目折后销售
     *
     * @param dto
     * @return
     */
    @Override
    public List<SalesGoalVo> restoreReplaySalesAfterDiscount(SalesGoalDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, BigDecimal> getSalesBeforeDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        Result<Map<String, BigDecimal>> result = salesGoalFeign.getSalesBeforeDiscount(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, BigDecimal> getSalesAfterDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        Result<Map<String, BigDecimal>> result = salesGoalFeign.getSalesAfterDiscount(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public String getLockKey(MasterDataMdgBaseDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesGoalSumVo findDiscountAfterAndDeliveryQuantity(SalesGoalDto salesGoalDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal findDiscountAfter(SalesGoalDto salesGoalDto) {
        return null;
    }

    /**
     * 销售任务：统计“年月+区域+系统”维度内控版的销售任务折后金额
     * @param salesGoalDtos
     * @return
     */
    @Override
    public List<SalesGoalVo> findListForFR(List<SalesGoalDto> salesGoalDtos) {
        return null;
    }
}
