package com.biz.crm.tpm.business.sales.goal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.task.PullSalesPerformanceTask;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @Description: 垂直销售业绩
 * @Author: dengwei
 * @Date: 2023/2/9 14:12
 * @Version: 1.0
 */
@RestController
@RequestMapping("/v1/sales/salesPerformance")
@Slf4j
@Api(tags = "垂直销售业绩")
public class SalesPerformanceController {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;

    @Autowired(required = false)
    private PullSalesPerformanceTask pullSalesPerformanceTask;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<SalesPerformanceVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "salesGoalDto", value = "销售目标信息") SalesPerformanceDto dto) {
        try {
            Page<SalesPerformanceVo> page = this.salesPerformanceService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动拉取数据")
    @GetMapping("timedTaskPullDay")
    public Result timedTaskPullDay() {

        try {
            UserIdentity loginUser = loginUserService.getAbstractLoginUser();
            CompletableFuture.runAsync(() -> {
                //刷新jwt
                loginUserService.refreshAuthentication(loginUser);

                this.pullSalesPerformanceTask.timedTaskPullDay();
            });
            return Result.ok("异步拉取数据中，请等待");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findSummaryByConditions")
    public Result<List<SalesDatePeriodSummaryVo>> findSummaryByConditions(
            @ApiParam(name = "salesGoalDto", value = "销售目标信息") SalesPerformanceDto dto,
            @ApiParam(name = "cacheKey", value = "缓存key(UUID+业务单元编码)") @RequestParam String cacheKey) {
        try {
            List<SalesDatePeriodSummaryVo> list = this.salesPerformanceService.findSummaryByConditions(dto, cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    @ApiOperation("手动拉取某一天数据")
    @PostMapping("pullDayData")
    public Result pullDayData(@RequestParam @ApiParam(name = "ds", value = "ds(yyyyMMdd 例：20230206)") String ds) {
        try {
            UserIdentity loginUser = loginUserService.getAbstractLoginUser();
            CompletableFuture.runAsync(() -> {
                //刷新jwt
                loginUserService.refreshAuthentication(loginUser);
                this.pullSalesPerformanceTask.pullDayData(ds);
            });
            return Result.ok("异步拉取数据中，请等待");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
