package com.biz.crm.tpm.business.sales.goal.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author huojia
 * @date 2022年10月25日 20:31
 */
@ApiModel(value = "SalesGoalEntity", description = "TPM-销售目标")
@TableName("tpm_sales_goal")
@Getter
@Setter
@Entity(name = "tpm_sales_goal")
@Table(name = "tpm_sales_goal",
        indexes = {@Index(name = "tpm_sales_goal_index1", columnList = "business_format_code, business_unit_code, year_month_ly"),
                @Index(name = "tpm_sales_goal_index2", columnList = "customer_code, year_month_ly"),
                @Index(name = "tpm_sales_goal_index3", columnList = "only_key"),
                @Index(name = "tpm_sales_goal_index4", columnList = "sales_org_province_code"),
                @Index(name = "tpm_sales_goal_index5", columnList = "modify_account"),
                @Index(name = "tpm_sales_goal_index6", columnList = "tenant_code,del_flag"),
                @Index(name = "tpm_sales_goal_index7", columnList = "year_month_ly,tenant_code,del_flag"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_goal", comment = "TPM-销售目标")
public class SalesGoalEntity extends TenantFlagOpEntity {

    /**
     * 维度配置编码（模板编码）
     */
    @ApiModelProperty("维度配置编码（模板编码）")
    @Column(name = "type_coding", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '维度配置编码（模板编码） '")
    private String typeCoding;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ApiModelProperty(name = "数据来源[数据字典:tpm_data_from]", notes = "")
    @Column(name = "data_from_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源[数据字典:tpm_data_from] '")
    private String dataFromCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(name = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 日历日
     */
    @ApiModelProperty(name = "日历日", notes = "")
    @Column(name = "calendar_day", nullable = true, length = 16, columnDefinition = "VARCHAR(32) COMMENT '日历日 '")
    private String calendarDay;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(name = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 年度销量分类[数据字典:tpm_year_sales_type]
     */
    @ApiModelProperty(name = "分组[数据字典:tpm_year_sales_type]", notes = "")
    @Column(name = "year_sales_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_year_sales_type] '")
    private String yearSalesTypeCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 销售机构erp编码
     */
    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构编码", notes = "销售机构erp编码")
    @Column(name = "sales_institution_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构erp编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty(name = "销售组织编码（大区）", notes = "")
    @Column(name = "sales_org_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码（大区） '")
    private String salesOrgRegionCode;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty(name = "销售组织名称（大区）", notes = "")
    @Column(name = "sales_org_region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称（大区） '")
    private String salesOrgRegionName;

    /**
     * 销售组织erp编码（大区）
     */
    @ApiModelProperty(name = "销售组织erp编码（大区）", notes = "")
    @Column(name = "sales_org_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码（大区） '")
    private String salesOrgRegionErpCode;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty(name = "销售组织编码（省区）", notes = "")
    @Column(name = "sales_org_province_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码（省区） '")
    private String salesOrgProvinceCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty(name = "销售组织名称（省区）", notes = "")
    @Column(name = "sales_org_province_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称（省区） '")
    private String salesOrgProvinceName;

    /**
     * 销售组织erp编码（省区）
     */
    @ApiModelProperty(name = "销售组织erp编码（省区）", notes = "")
    @Column(name = "sales_org_province_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码（省区） '")
    private String salesOrgProvinceErpCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 销售组
     */
    @ApiModelProperty(name = "salesGroupName", value = "销售组", notes = "销售组")
    @Column(name = "sales_group_name", nullable = true, length = 255, columnDefinition = "VARCHAR(64) COMMENT '销售组 '")
    private String salesGroupName;

    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode", value = "销售组编码", notes = "销售组编码")
    @Column(name = "sales_group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "")
    @Column(name = "sales_org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级 '")
    private String salesOrgLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    @Column(name = "customer_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道层级 '")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    @Column(name = "terminal_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道层级 '")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    @Column(name = "terminal_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道编码 '")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    @Column(name = "terminal_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店渠道名称 '")
    private String terminalChannelName;

    /**
     * 行政省编码
     */
    @ApiModelProperty(name = "行政省编码", notes = "")
    @Column(name = "province_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '行政省编码 '")
    private String provinceCode;

    /**
     * 行政省名称
     */
    @ApiModelProperty(name = "行政省名称", notes = "")
    @Column(name = "province_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '行政省名称 '")
    private String provinceName;

    /**
     * 城市编码
     */
    @ApiModelProperty(name = "城市编码", notes = "")
    @Column(name = "city_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '城市编码 '")
    private String cityCode;

    /**
     * 城市名称
     */
    @ApiModelProperty(name = "城市名称", notes = "")
    @Column(name = "city_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '城市名称 '")
    private String cityName;

    /**
     * 系统编码
     */
    @ApiModelProperty(name = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(name = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 客户erp编码
     */
    @ApiModelProperty(name = "客户erp编码", notes = "")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户erp编码 '")
    private String customerErpCode;

    /**
     * 客户类型
     */
    @ApiModelProperty(name = "客户类型", notes = "")
    @Column(name = "customer_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型 '")
    private String customerType;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "")
    @Column(name = "region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称 '")
    private String regionName;

    /**
     * 新老品
     */
    @ApiModelProperty(name = "新老品", notes = "")
    @Column(name = "new_old_product", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '新老品 '")
    private String newOldProduct;

    /**
     * KAD编码
     */
    @ApiModelProperty(name = "KAD编码", notes = "")
    @Column(name = "kad_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'KAD编码 '")
    private String kadCode;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 大品牌编码
     */
    @ApiModelProperty(name = "大品牌编码", notes = "")
    @Column(name = "big_product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '大品牌编码 '")
    private String bigProductBrandCode;

    /**
     * 大品牌名称
     */
    @ApiModelProperty(name = "大品牌名称", notes = "")
    @Column(name = "big_product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '大品牌名称 '")
    private String bigProductBrandName;

    /**
     * 品牌细分编码
     */
    @ApiModelProperty(name = "品牌细分编码", notes = "")
    @Column(name = "detail_product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌细分编码 '")
    private String detailProductBrandCode;

    /**
     * 品牌细分名称
     */
    @ApiModelProperty(name = "品牌细分名称", notes = "")
    @Column(name = "detail_product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌细分名称 '")
    private String detailProductBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品名称 '")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty(name = "单位编码", notes = "")
    @Column(name = "unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码 '")
    private String unitCode;

    /**
     * 单位名称
     */
    @ApiModelProperty(name = "单位名称", notes = "")
    @Column(name = "unit_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '单位名称 '")
    private String unitName;

    /**
     * 单价
     */
    @ApiModelProperty(name = "单价", notes = "")
    @Column(name = "price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '单价 '")
    private BigDecimal price;

    /**
     * 吨位
     */
    @ApiModelProperty(name = "吨位", notes = "")
    @Column(name = "tonnage", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '单价 '")
    private BigDecimal tonnage;

    /**
     * 任务量
     */
    @ApiModelProperty(name = "任务量", notes = "")
    @Column(name = "task_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '任务量 '")
    private BigDecimal taskQuantity;

    /**
     * 进货折前销售额
     */
    @ApiModelProperty(name = "进货折前销售额", notes = "")
    @Column(name = "purchase_sales_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '进货折前销售额 '")
    private BigDecimal purchaseSalesAmount;

    /**
     * 进货折后销售额
     */
    @ApiModelProperty(name = "进货折后销售额", notes = "")
    @Column(name = "purchase_discount_sales_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '进货折后销售额 '")
    private BigDecimal purchaseDiscountSalesAmount;

    /**
     * 出库折前销售额
     */
    @ApiModelProperty(name = "出库折前销售额", notes = "")
    @Column(name = "delivery_sales_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '出库折前销售额 '")
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    @ApiModelProperty(name = "出库折后销售额", notes = "")
    @Column(name = "delivery_discount_sales_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '出库折后销售额 '")
    private BigDecimal deliveryDiscountSalesAmount;

    /**
     * 出库量
     */
    @ApiModelProperty(name = "出库量", notes = "")
    @Column(name = "delivery_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '出库量 '")
    private BigDecimal deliveryQuantity;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 唯一键（business_format_code,business_unit_code,year_month_ly,year_sales_type_code,
     *             sales_institution_erp_code,
     *             customer_code,customer_type,product_code）
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "only_key", columnDefinition = "varchar(255) COMMENT '唯一键'")
    private String onlyKey;
}
