package com.biz.crm.tpm.business.sales.goal.local.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author huxmld
 * @TableName tpm_sales_performance
 */
@ApiModel(value = "SalesPerformanceEntity", description = "垂直销售业绩")
@TableName(value = "tpm_sales_performance")
@Entity(name = "tpm_sales_performance")
@Table(name = "tpm_sales_performance",
        indexes = {
                @Index(name = "tpm_sales_performance_index1", columnList = "sales_month"),
                @Index(name = "tpm_sales_performance_index2", columnList = "sales_date"),
                @Index(name = "tpm_sales_performance_index3", columnList = "tenant_code,del_flag"),
                @Index(name = "tpm_sales_performance_index4", columnList = "sold_toparty"),
                @Index(name = "tpm_sales_performance_index5", columnList = "ship_toparty"),
                @Index(name = "tpm_sales_performance_index6", columnList = "region,retailer,sales_month"),
                @Index(name = "tpm_sales_performance_index7", columnList = "year_col"),
                @Index(name = "tpm_sales_performance_index8", columnList = "retailer"),
                @Index(name = "tpm_sales_performance_index9", columnList = "region"),
                @Index(name = "tpm_sales_performance_index10", columnList = "year_col,retailer,region"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_performance", comment = "TPM-垂直销售业绩")
@Data
public class SalesPerformanceEntity implements Serializable {

    private static final long serialVersionUID = 9116339559679816359L;
    /**
     * id
     */
    @ApiModelProperty("主键id")
    @TableField(value = "sp_id")
    @Id
    @GeneratedValue(
            generator = "uuid"
    )
    @TableId(
            type = IdType.ASSIGN_UUID
    )
    @GenericGenerator(
            name = "uuid",
            strategy = "org.hibernate.id.UUIDGenerator"
    )
    private String spId;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @Column(name = "sales_date", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT '日期'")
    private String salesDate;

    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    @TableField(value = "sales_org")
    private String salesOrg;

    /**
     * 销售大区
     */
    @ApiModelProperty("销售大区")
    @TableField(value = "region")
    private String region;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    @TableField(value = "brand")
    private String brand;

    /**
     * 品项
     */
    @ApiModelProperty("品项")
    @TableField(value = "category_code")
    private String categoryCode;

    /**
     * 品类划分
     */
    @ApiModelProperty("日期")
    @TableField(value = "classify")
    private String classify;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 产品类型（新品、主品等）
     */
    @ApiModelProperty("产品类型（新品、主品等）")
    @TableField(value = "product_type")
    private String productType;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @TableField(value = "material_code")
    private String materialCode;

    /**
     * 运达方（送达方）
     */
    @ApiModelProperty(" 运达方（送达方）")
    @TableField(value = "ship_toparty")
    @Column(name = "ship_toparty", nullable = false, length = 256, columnDefinition = "VARCHAR(256) COMMENT '运达方（送达方）'")
    private String shipToparty;

    /**
     * 送达方名称(门店名称)
     */
    @ApiModelProperty("送达方名称(门店名称)")
    @TableField(value = "ship_toparty_name")
    private String shipTopartyName;

    /**
     * 售达方名称出
     */
    @ApiModelProperty("系统（售达方）")
    @TableField(value = "sold_topart_name")
    private String soldTopartName;

    /**
     * 系统（售达方）
     */
    @ApiModelProperty("系统（售达方）")
    @TableField(value = "sold_toparty")
    @Column(name = "sold_toparty", nullable = false, length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统（售达方）'")
    private String soldToparty;

    /**
     * 零售商
     */
    @ApiModelProperty(" 零售商")
    @TableField(value = "retailer")
    private String retailer;

    /**
     * 出库数量(收货订单数量)
     */
    @ApiModelProperty(" 出库数量(收货订单数量)")
    @TableField(value = "warehs_out_qty")
    private BigDecimal warehsOutQty;

    /**
     * 出库折扣
     */
    @ApiModelProperty("出库折扣")
    @TableField(value = "actual_discount")
    private BigDecimal actualDiscount;

    /**
     * 折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("折前金额(订单含返点常规金额)")
    @TableField(value = "order_rule_amt_in_rebate")
    private BigDecimal orderRuleAmtInRebate;

    /**
     * 折后实际销额
     */
    @ApiModelProperty("折后实际销额")
    @TableField(value = "warehs_out_discount_amt")
    private BigDecimal warehsOutDiscountAmt;

    /**
     * 月累出库数量(收货订单数量)
     */
    @ApiModelProperty("月累出库数量(收货订单数量)")
    @TableField(value = "warehs_out_qty_inc_m")
    private BigDecimal warehsOutQtyIncM;

    /**
     * 月累出库折扣
     */
    @ApiModelProperty("月累出库折扣")
    @TableField(value = "actual_discount_inc_m")
    private BigDecimal actualDiscountIncM;

    /**
     * 月累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("月累折前金额(订单含返点常规金额)")
    @TableField(value = "order_rule_amt_in_rebate_inc_m")
    private BigDecimal orderRuleAmtInRebateIncM;

    /**
     * 月累折后实际销额
     */
    @ApiModelProperty("月累折后实际销额")
    @TableField(value = "warehs_out_discount_amt_inc_m")
    private BigDecimal warehsOutDiscountAmtIncM;

    /**
     * 年累出库数量(收货订单数量)
     */
    @ApiModelProperty("年累出库数量(收货订单数量)")
    @TableField(value = "warehs_out_qty_inc_y")
    private BigDecimal warehsOutQtyIncY;

    /**
     * 年累出库折扣
     */
    @ApiModelProperty("年累出库折扣")
    @TableField(value = "actual_discount_inc_y")
    private BigDecimal actualDiscountIncY;

    /**
     * 年累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("年累折前金额(订单含返点常规金额)")
    @TableField(value = "order_rule_amt_in_rebate_inc_y")
    private BigDecimal orderRuleAmtInRebateIncY;

    /**
     * 年累折后实际销额
     */
    @ApiModelProperty("年累折后实际销额")
    @TableField(value = "warehs_out_discount_amt_inc_y")
    private BigDecimal warehsOutDiscountAmtIncY;

    @ApiModelProperty("删除标记")
    @TableField(value = "del_flag")
    @Column(name = "del_flag", nullable = false, length = 8, columnDefinition = "VARCHAR(8) COMMENT '删除标记'")
    private String delFlag;

    @ApiModelProperty("是否启用")
    @TableField(value = "enable_status")
    @Column(name = "enable_status", nullable = false, length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否启用'")
    private String enableStatus;

    @ApiModelProperty("租客编号")
    @Column(name = "tenant_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '租客编号'")
    private String tenantCode;

    @ApiModelProperty("销售 年 yyyy")
    @TableField(value = "year_col")
    @Column(name = "year_col", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT '销售 年 yyyy'")
    private String yearCol;

    @ApiModelProperty("销售 月份 yyyyMM")
    @Column(name = "sales_month", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT '销售 月份 yyyyMM'")
    private String salesMonth;

}