package com.biz.crm.tpm.business.sales.goal.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceExportVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: chenlong
 * @date: 2023/4/11 10:01
 * @description: 垂直销售业绩导出
 */
@Component
public class SalesPerformanceExportsProcess implements ExportProcess<SalesPerformanceExportVo> {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        SalesPerformanceDto dto = this.convertParams(params);
        Page<SalesPerformanceVo> pageResult = this.salesPerformanceService.findByConditions(PageRequest.of(0, 1), dto);
        Integer total = (int) pageResult.getTotal();
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private SalesPerformanceDto convertParams(Map<String, Object> params) {
        return JSON.parseObject(JSON.toJSONString(params), SalesPerformanceDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SalesPerformanceDto dto = this.convertParams(params);
        Page<SalesPerformanceVo> page = this.salesPerformanceService.findByConditions(PageRequest.of(vo.getPageNo() + 1, this.getPageSize()), dto);
        return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
    }

    @Override
    public Class<SalesPerformanceExportVo> findCrmExcelVoClass() {
        return SalesPerformanceExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SALES_PERFORMANCE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "垂直销售业绩导出";
    }

    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private List<SalesPerformanceExportVo> adjustData(List<SalesPerformanceVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<>(0);
        }
        Collection<SalesPerformanceExportVo> list = this.nebulaToolkitService.copyCollectionByWhiteList(
                data, SalesPerformanceVo.class, SalesPerformanceExportVo.class, HashSet.class, ArrayList.class
        );
        return (List<SalesPerformanceExportVo>) list;
    }
}
