package com.biz.crm.tpm.business.sales.goal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 11:20
 */
public interface SalesGoalMapper extends BaseMapper<SalesGoalEntity> {

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2022/10/26 11:22
     **/
    Page<SalesGoalVo> findByConditions(Page<SalesGoalVo> page, @Param("dto") SalesGoalDto dto);

    /**
     * 条件查询销售目标
     *
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity>
     * @author huojia
     * @date 2022/11/4 11:05
     **/
    List<SalesGoalEntity> listByConditions(@Param("dto") SalesGoalDto salesGoalDto);

    /**
     * 分页统计销售目标任务量
     *
     * @param page 分页参数
     * @param dto  筛选参数
     * @return Page<SalesGoalStatisticsVo>
     **/
    Page<SalesGoalStatisticsVo> listTaskQuantityPage(Page<SalesGoalStatisticsVo> page, @Param("dto") SalesGoalStatisticsDto dto);

    /**
     * 查询按区域分组的数据
     *
     * @param dto 查询对象
     * @return
     */
    List<SalesGoalVo> findListGroupByRegion(@Param("dto") SalesGoalDto dto);

    /**
     * 批量查询垂直销售任务
     *
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity>
     * @author huojia
     * @date 2023/1/17 0:53
     **/
    List<SalesGoalEntity> listVerticalByConditions(@Param("dto") SalesGoalDto salesGoalDto);

    /**
     * 条件删除
     *
     * @param calender
     * @param dto
     * @author huojia
     * @date 2023/1/17 2:43
     **/
    void delByCalendar(@Param("calender") String calender, @Param("dto") MasterDataMdgBaseDto dto);

    /**
     * 导入，大批量数据导入
     *
     * @param salesGoalEntities
     * @author huojia
     * @date 2023/1/28 17:47
     **/
    void importSaveBatch(@Param("salesGoals") List<SalesGoalEntity> salesGoalEntities);

    /**
     * 批量汇总
     *
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo>
     * @author huojia
     * @date 2023/2/9 11:00
     **/
    List<SalesGoalSumVo> listVerticalSumByConditions(@Param("dto") SalesGoalDto salesGoalDto);

    /**
     * 根据维度组装的key查询销售任务数据
     *
     * @param onlyKeys   维度组装的key
     * @param tenantCode 租户编码
     * @return List<SalesGoalEntity>
     **/
    List<SalesGoalEntity> getSalesGoalByKeys(@Param("onlyKeys") List<List<String>> onlyKeys, @Param("tenantCode") String tenantCode);


    /**
     * 查询金额
     * @param salesGoal 查询参数
     * @param queryType 查询类型
     * @return BigDecimal
     */
    BigDecimal getSalesGoalAmount(@Param("salesGoal") SalesGoalDto salesGoal);

    /**
     * 根据业态，业务单元，分组，年月，统计折前销量，按照零售商+区域分组，-隔开
     *
     * @param dto 统计参数
     * @return List<SalesGoalVo>
     */
    List<SalesGoalVo> getSalesBeforeDiscount(@Param("dto") SalesGoalDiscountSalesStatisticsDto dto);

    /**
     * 根据业态，业务单元，分组，年月，统计折后销量，按照零售商+区域分组，-隔开
     *
     * @param dto 统计参数
     * @return List<SalesGoalVo>
     */
    List<SalesGoalVo> getSalesAfterDiscount(@Param("dto") SalesGoalDiscountSalesStatisticsDto dto);

    List<SalesGoalVo> restoreReplaySalesAfterDiscount(@Param("dto") SalesGoalDto dto);

    /**
     * 根据参数统计折后额和出库数
     *
     * @param salesGoalDto 参数
     * @return SalesGoalSumVo
     */
    SalesGoalSumVo findDiscountAfterAndDeliveryQuantity(@Param("dto") SalesGoalDto salesGoalDto);

    /**
     * 按维度获取折后销售额
     * @param salesGoalDto
     * @return
     */
    BigDecimal findDiscountAfter(@Param("dto")SalesGoalDto salesGoalDto);

    /**
     * 销售任务：统计“年月+区域+系统”维度内控版的销售任务折后金额
     * @param salesGoalDtos
     * @return
     */
    List<SalesGoalVo> findListForFR(@Param("dto") List<SalesGoalDto> salesGoalDtos);
}
