package com.biz.crm.tpm.business.sales.goal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgSalesPerformanceDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesPerformanceVo;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceStatisDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceStatisVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Entity com.biz.crm.tpm.business.sales.goal.local.entity.domain.TpmSalesPerformance
 */
public interface SalesPerformanceMapper extends BaseMapper<SalesPerformanceEntity> {

    void saveBatchSalesPerformance(List<MasterDataMdgSalesPerformanceVo> masterDataMdgSalesPerformanceVos);

    void saveBatchSalesPerformanceByYearAndMonth(@Param("list") List<MasterDataMdgSalesPerformanceVo> masterDataMdgSalesPerformanceVos,@Param("yearMonth") String yearMonth);

    void deleteBatch(@Param("dto") MasterDataMdgSalesPerformanceDto dto);

    void createTableByYearMonth(@Param("yearMonth") String yearMonth);

    void deleteBatchByYearAndMonth(@Param("dto") MasterDataMdgSalesPerformanceDto dto,@Param("size") Integer size);

    Integer totalCount(@Param("dto") MasterDataMdgSalesPerformanceDto dto);

    Page<SalesPerformanceVo> findByConditions(@Param("page") Page<SalesPerformanceVo> page,@Param("dto") SalesPerformanceDto dto);

    Integer isExist(@Param("tableName") String tableName);

    List<SalesPerformanceSumVo> listByConditions(@Param("dto") SalesPerformanceDto dto);

    Integer findTotalByCondition(@Param("dto") SalesPerformanceDto salesPerformanceDto);
    /**
     * 根据活动开始结束时间，零售商区域，统计此维度下的每个品牌的折扣实际销额
     *
     * @param dto 垂直销售业绩数据筛选参数
     * @return List<SalesPerformanceStatisVo>
     */
    List<SalesPerformanceStatisVo> statisSalesAmountByBrand(@Param("dto") SalesPerformanceStatisDto dto);

    List<SalesDatePeriodSummaryVo> findSummaryByConditions(@Param("dto") SalesPerformanceDto dto);

    /**
     * 计算折后实际销额与出库数量
     * @param dto
     * @return
     */
    SalesPerformanceVo findSalesAmountAndOutNumber(@Param("dto") SalesPerformanceDto dto);

    List<SalesPerformanceVo> findSalesPerformanceSumVo(@Param("dto") SalesPerformanceDto queryDto);

    /**
     * 计算折后实际销额
     * @param dto
     * @return
     */
    BigDecimal findSalesAmount(@Param("dto") SalesPerformanceDto dto);

    List<SalesPerformanceVo> findListForFR(@Param("dtos") List<SalesPerformanceDto> salesPerformanceDtos);

    List<SalesPerformanceVo> findBusinessUnitSetTableForFR(@Param("dtos") List<SalesPerformanceDto> salesPerformanceDtos);
}




