package com.biz.crm.tpm.business.sales.goal.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年11月07日 17:10
 */
@Component
public class SalesGoalRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_budget_sales_goal_data_view";
    }

    @Override
    public String desc() {
        return "TPM-预算管理-销售目标";
    }

    @Override
    public String buildSql() {
        return " select a.id," +
                "a.create_account," +
                "a.create_name," +
                "a.create_time," +
                "a.modify_account," +
                "a.modify_name," +
                "a.modify_time," +
                "a.del_flag," +
                "a.enable_status," +
                "a.remark," +
                "a.tenant_code," +
                "a.business_format_code," +
                "a.business_unit_code," +
                "a.customer_channel_code," +
                "a.customer_channel_level_code," +
                "a.customer_channel_name," +
                "a.customer_code," +
                "a.customer_erp_code," +
                "a.customer_name," +
                "a.customer_type," +
                "a.data_from_code," +
                "a.group_code," +
                "a.product_brand_code," +
                "a.product_brand_name," +
                "a.product_category_code," +
                "a.product_category_name," +
                "a.product_code," +
                "a.product_item_name," +
                "a.product_item_code," +
                "a.product_name," +
                "a.sales_org_code," +
                "a.sales_org_level_code," +
                "a.sales_org_name," +
                "a.system_code," +
                "a.system_name," +
                "a.task_quantity," +
                "a.terminal_channel_code," +
                "a.sales_org_province_name," +
                "a.terminal_name," +
                "a.sales_institution_name," +
                "a.unit_code," +
                "a.calendar_day," +
                "a.region_name," +
                "a.terminal_channel_name," +
                "a.kad_code," +
                "a.terminal_code," +
                "a.sales_group_code," +
                "a.terminal_channel_level_code," +
                "a.sales_org_region_code," +
                "a.type_coding," +
                "a.sales_org_region_name," +
                "a.province_name," +
                "a.unit_name," +
                "a.sales_institution_code," +
                "a.year_month_ly," +
                "a.detail_product_brand_code," +
                "a.year_sales_type_code," +
                "a.city_name," +
                "a.city_code," +
                "a.sales_org_province_code," +
                "a.big_product_brand_code," +
                "a.sales_group_name," +
                "a.big_product_brand_name," +
                "a.province_code," +
                "a.new_old_product," +
                "a.region_code," +
                "a.detail_product_brand_name," +
                "a.channel_code," +
                "a.channel_name," +
                "a.sales_org_region_erp_code," +
                "TRUNCATE(price, 2) as price," +
                "TRUNCATE(tonnage, 2) as tonnage," +
                "TRUNCATE(a.purchase_sales_amount, 2) as purchase_sales_amount," +
                "TRUNCATE(a.purchase_discount_sales_amount, 2) as purchase_discount_sales_amount," +
                "TRUNCATE(a.delivery_sales_amount, 2) as delivery_sales_amount," +
                "TRUNCATE(a.delivery_discount_sales_amount, 2) as delivery_discount_sales_amount," +
                "TRUNCATE(a.delivery_quantity, 2) as delivery_quantity " +
                "from tpm_sales_goal a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}


