package com.biz.crm.tpm.business.sales.goal.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgSalesPerformanceDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesPerformanceVo;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 *
 */
public interface SalesPerformanceService extends IService<SalesPerformanceEntity> {

    void removeBatch(MasterDataMdgSalesPerformanceDto dto, Integer delPage, Integer size);

    void saveBatchSalesPerformance(List<MasterDataMdgSalesPerformanceVo> masterDataMdgSalesPerformanceVos, MasterDataMdgSalesPerformanceDto dto);

    Integer totalCount(MasterDataMdgSalesPerformanceDto dto);

    Page<SalesPerformanceVo> findByConditions(Pageable pageable, SalesPerformanceDto dto);

    Integer findTotalByCondition(SalesPerformanceDto salesPerformanceDto);

    List<SalesDatePeriodSummaryVo> findSummaryByConditions(SalesPerformanceDto dto, String cacheKey);

    /**
     * 计算折后实际销额与出库数量
     * @param dto
     * @return
     */
    SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto);
}
