package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity;
import com.biz.crm.tpm.business.sales.goal.local.repository.SalesGoalRepository;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesGoaEditService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/2/22 10:46
 * @description: 销售任务数据修改服务接口实现类
 */
@Slf4j
@Service
public class SalesGoaEditServiceImpl implements SalesGoaEditService {

    @Autowired(required = false)
    private SalesGoalRepository salesGoalRepository;


    /**
     * 批量修改销售任务数据
     *
     * @param list 销售任务数据列表
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editBatch(List<SalesGoalEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        //获取唯一维度key
        List<String> onlyKeys = new ArrayList<>();
        for (SalesGoalEntity entity : list) {
            String onlyKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode()
                    + entity.getYearMonthLy() + entity.getYearSalesTypeCode() + entity.getSalesInstitutionErpCode()
                    + entity.getSalesOrgRegionErpCode()+entity.getSalesOrgProvinceErpCode()
                    + entity.getCustomerCode() + entity.getCustomerType() + entity.getProductCode();
            entity.setOnlyKey(onlyKey);
            onlyKeys.add(onlyKey);
        }
        //通过唯一键查询历史数据
        List<SalesGoalEntity> oldList = this.salesGoalRepository.getSalesGoalByKeys(onlyKeys, TenantUtils.getTenantCode());
        Map<String, String> oldMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(oldList)) {
            oldMap = oldList.stream().collect(Collectors.toMap(SalesGoalEntity::getOnlyKey,
                    SalesGoalEntity::getId));
        }
        List<SalesGoalEntity> editList = new ArrayList<>();
        List<SalesGoalEntity> addList = new ArrayList<>();
        for (SalesGoalEntity entity : list) {
            entity.setTenantCode(TenantUtils.getTenantCode());
            if (oldMap.containsKey(entity.getOnlyKey())) {
                entity.setId(oldMap.get(entity.getOnlyKey()));
                editList.add(entity);
            } else {
                addList.add(entity);
            }
        }
        //更新数据
        if (!CollectionUtils.isEmpty(editList)) {
            this.salesGoalRepository.updateBatchById(editList);
        }
        //新增数据
        if (!CollectionUtils.isEmpty(addList)) {
            this.salesGoalRepository.saveBatch(addList);
        }
    }
}
