package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgSalesPerformanceDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesPerformanceVo;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesPerformanceMapper;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.SalesPerformanceConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 */
@Service
@Slf4j
public class SalesPerformanceServiceImpl extends ServiceImpl<SalesPerformanceMapper, SalesPerformanceEntity>
    implements SalesPerformanceService {

    @Resource
    private SalesPerformanceMapper salesPerformanceMapper;

    @Autowired(required = false)
    private Snowflake snowflake;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Autowired(required = false)
    private ProductBrandService productBrandService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void removeBatch(MasterDataMdgSalesPerformanceDto dto, Integer delPage, Integer size) {

        //分表
        if(true){
            for (int i = 0; i < delPage; i++) {
                salesPerformanceMapper.deleteBatchByYearAndMonth(dto,size);
            }
        }else {
            //老逻辑
            for (int i = 0; i < delPage; i++) {
                salesPerformanceMapper.deleteBatch(dto);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBatchSalesPerformance(List<MasterDataMdgSalesPerformanceVo> masterDataMdgSalesPerformanceVos, MasterDataMdgSalesPerformanceDto dto) {

        //分表
        if(true){
            if(CollectionUtils.isNotEmpty(masterDataMdgSalesPerformanceVos)) {
                //如果是新一个月的数据，就要创建新表
                String yearMonth = dto.getSalesMonth();
                //2023-05-17 每月数据不多 不分表了
                //checkAndCreate(yearMonth);
                masterDataMdgSalesPerformanceVos.forEach(masterDataMdgSalesPerformanceVo -> {
                    masterDataMdgSalesPerformanceVo.setSpId(snowflake.nextIdStr());
                    masterDataMdgSalesPerformanceVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    masterDataMdgSalesPerformanceVo.setTenantCode(TenantUtils.getTenantCode());
                });
                salesPerformanceMapper.saveBatchSalesPerformanceByYearAndMonth(masterDataMdgSalesPerformanceVos,yearMonth);
                log.info("垂直销售业绩保存成功");
            }

        }else {
            //老逻辑
            if (CollectionUtils.isNotEmpty(masterDataMdgSalesPerformanceVos)) {
                masterDataMdgSalesPerformanceVos.stream().forEach(masterDataMdgSalesPerformanceVo -> {
                    masterDataMdgSalesPerformanceVo.setSpId(snowflake.nextIdStr());
                });
                salesPerformanceMapper.saveBatchSalesPerformance(masterDataMdgSalesPerformanceVos);
            }
        }
    }

    @Override
    public Integer totalCount(MasterDataMdgSalesPerformanceDto dto) {
            return salesPerformanceMapper.totalCount(dto);
    }

    @Override
    public Page<SalesPerformanceVo> findByConditions(Pageable pageable, SalesPerformanceDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Validate.notNull(dto,"输入参数不能为空");
        Validate.notBlank(dto.getSalesMonth(),"请选择年月");
        if(dto.getSalesMonth().contains("-")){
            dto.setSalesMonth(dto.getSalesMonth().replace("-",""));
        }
        Page<SalesPerformanceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SalesPerformanceVo> salesPerformanceVoPage = this.salesPerformanceMapper.findByConditions(page, dto);
        List<SalesPerformanceVo> records = salesPerformanceVoPage.getRecords();
        if (CollectionUtils.isNotEmpty(records)
                && (!YesOrNoEnum.NO.getCode().equals(dto.getIsExtend()))) {
            List<String> brands = records
                    .stream()
                    .filter(k->StringUtils.isNotBlank(k.getBrand()))
                    .map(SalesPerformanceVo::getBrand)
                    .distinct()
                    .collect(Collectors.toList());
            Map<String, ProductBrandVo> brandVoMap = productBrandService
                    .listByCodes(brands)
                    .stream()
                    .filter(k->StringUtils.isNotBlank(k.getProductBrandCode()))
                    .collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity(), (b1, b2) -> b2));
            //品项
            List<String> categoryCodes = records
                    .stream()
                    .filter(k->StringUtils.isNotBlank(k.getCategoryCode()))
                    .map(SalesPerformanceVo::getCategoryCode)
                    .distinct()
                    .collect(Collectors.toList());
            List<String> classifys = records.stream()
                    .filter(k->StringUtils.isNotBlank(k.getClassify()))
                    .map(SalesPerformanceVo::getClassify).distinct().collect(Collectors.toList());
            categoryCodes.addAll(classifys);
            List<ProductLevelVo> productLevelVoList = productLevelVoSdkService.findListByCodes(categoryCodes);
            //根据productLevelType分类
            Map<ProductLevelEnum, List<ProductLevelVo>> productLevelEnumMap = productLevelVoList
                    .stream()
                    .collect(Collectors.groupingBy(ProductLevelVo::getProductLevelType));
            //品类
            List<ProductLevelVo> productLevelCategoryList = productLevelEnumMap.get(ProductLevelEnum.category);
            Map<String, ProductLevelVo> categoryMap = productLevelCategoryList
                    .stream()
                    .collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (p1, p2) -> p2));
            //品项
            List<ProductLevelVo> productLevelItemsList = productLevelEnumMap.get(ProductLevelEnum.items);
            Map<String, ProductLevelVo> itemCodeMap = productLevelItemsList
                    .stream()
                    .collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (pl1, pl2) -> pl2));
            records.forEach(salesPerformanceVo -> {
                String brand = salesPerformanceVo.getBrand();
                if (brandVoMap.containsKey(brand)) {
                    salesPerformanceVo.setBrand(brandVoMap.get(brand).getProductBrandName());
                }

                //品类
                String classify = salesPerformanceVo.getClassify();
                if (categoryMap.containsKey(classify)) {
                    ProductLevelVo productLevelVoClassify = categoryMap.get(classify);
                    salesPerformanceVo.setClassify(productLevelVoClassify.getProductLevelName());
                }

                //品项
                String categoryCode = salesPerformanceVo.getCategoryCode();
                if (itemCodeMap.containsKey(categoryCode)) {
                    ProductLevelVo productLevelVo = itemCodeMap.get(categoryCode);
                    salesPerformanceVo.setCategoryCode(productLevelVo.getProductLevelName());
                }

            });
            salesPerformanceVoPage.setRecords(records);
        }
        return salesPerformanceVoPage;
    }

    @Override
    public Integer findTotalByCondition(SalesPerformanceDto salesPerformanceDto) {
        if(Objects.nonNull(salesPerformanceDto)){
            return 0;
        }
        return salesPerformanceMapper.findTotalByCondition(salesPerformanceDto);
    }

    /**
     * 2023-05-17 不分表了，注释一下
     * @param yearMonth
     */
    @Deprecated
    private void checkAndCreate(String yearMonth) {
        if (!redisService.hasKey(SalesPerformanceConstant.VERTICAL_SALES_PERFORMANCE)) {
            redisService.set(SalesPerformanceConstant.VERTICAL_SALES_PERFORMANCE,yearMonth);
            //初始化创建
//            String tableName = "tpm_sales_performance_" + yearMonth;
//            Integer number = salesPerformanceMapper.isExist(tableName);
//            if(number<=0) {
                this.salesPerformanceMapper.createTableByYearMonth(yearMonth);
//            }
            return;
        }
        String yearMonth2 = (String)redisService.get(SalesPerformanceConstant.VERTICAL_SALES_PERFORMANCE);
        if(!yearMonth.equals(yearMonth2)){
            //根据年月创建一张表
//            String tableName = "tpm_sales_performance_" + yearMonth;
//            Integer number = salesPerformanceMapper.isExist(tableName);
//            if(number<=0) {
                this.salesPerformanceMapper.createTableByYearMonth(yearMonth);
                redisService.set(SalesPerformanceConstant.VERTICAL_SALES_PERFORMANCE, yearMonth);
//            }
        }
    }

    @Override
    public List<SalesDatePeriodSummaryVo> findSummaryByConditions(SalesPerformanceDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty(dto.getStartTimeOrDate()) && StringUtils.isNotEmpty(dto.getEndTimeOrDate())) {
            Validate.isTrue(StringUtils.equals(dto.getStartTimeOrDate().substring(0, 7), dto.getEndTimeOrDate().substring(0, 7)), "查询时间不能跨月！");
        }

        cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
        if (StringUtils.isNotEmpty(cacheKey)) {
            redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty(dto.getStartTimeOrDate())
                || StringUtils.isEmpty(dto.getCustomerCode())
                || StringUtils.isEmpty(dto.getEndTimeOrDate())) {
            return Lists.newArrayList();
        }

        //用的MDG客户编码查询
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(com.google.common.collect.Lists.newArrayList(dto.getCustomerCode()));
        Validate.notEmpty(customerVos, "客户编码[%s]客户信息不存在！", dto.getCustomerCode());
        dto.setSoldToparty(customerVos.get(0).getErpCode());

        String beginDate = dto.getStartTimeOrDate().replaceAll("-", "");
        String endDate = dto.getEndTimeOrDate().replaceAll("-", "");
        //判断是否跨月
        String beginYearMonthStr = dto.getStartTimeOrDate().substring(0,7);
        String endYearMonthStr = dto.getEndTimeOrDate().substring(0,7);

        List<SalesDatePeriodSummaryVo> list = new ArrayList<>();
        if(beginYearMonthStr.equals(endYearMonthStr)){
            dto.setStartTimeOrDate(beginDate);
            dto.setEndTimeOrDate(endDate);
            dto.setSalesMonth(beginYearMonthStr.substring(0,4) + beginYearMonthStr.substring(5,7));
//            String tableName = "tpm_sales_performance_" + dto.getSalesMonth();
//            Integer number = salesPerformanceMapper.isExist(tableName);
//            if(number >0 ) {
                list = this.salesPerformanceMapper.findSummaryByConditions(dto);
//            }
        }
        //跨月，因为垂直拆表，需要拼接查询
        else {
            List<SalesDatePeriodSummaryVo> result = new ArrayList<>();
            Calendar beginDateCalendar = Calendar.getInstance();
            beginDateCalendar.setTime(DateUtil.parse(dto.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            String currentYearMonth = dto.getStartTimeOrDate().substring(0,7);
            while(currentYearMonth.compareTo(endYearMonthStr) != 1){
                dto.setSalesMonth(currentYearMonth.replaceAll("-", ""));
//                String tableName = "tpm_sales_performance_" + dto.getSalesMonth();
//                Integer number = salesPerformanceMapper.isExist(tableName);
//                if(number >0 ) {
                    //实际转化成3种情况，在开始月，在结束月，在开始月结束月之间
                    if(currentYearMonth.equals(beginYearMonthStr)) {
                        dto.setStartTimeOrDate(beginDate);
                        dto.setEndTimeOrDate(null);
                    } else if (currentYearMonth.equals(endYearMonthStr)) {
                        dto.setStartTimeOrDate(null);
                        dto.setEndTimeOrDate(endDate);
                    } else {
                        dto.setStartTimeOrDate(null);
                        dto.setEndTimeOrDate(null);
                    }
                    result.addAll(this.salesPerformanceMapper.findSummaryByConditions(dto));
//                }
                beginDateCalendar.add(Calendar.MONTH, 1);
                currentYearMonth = DateUtil.format(beginDateCalendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
            }
            //合并各月数据
            Map<String, List<SalesDatePeriodSummaryVo>> resultMap = result.stream().collect(Collectors.groupingBy(SalesDatePeriodSummaryVo::getProductCode));
            for(String key : resultMap.keySet()){
                List<SalesDatePeriodSummaryVo> resultList = resultMap.get(key);
                if(CollectionUtils.isNotEmpty(resultList)){
                    BigDecimal totalQuantity = resultList.stream().map(SalesDatePeriodSummaryVo::getWarehsOutDiscountAmtIncY).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    resultList.get(0).setWarehsOutDiscountAmtIncY(totalQuantity);
                    list.add(resultList.get(0));
                }
            }
        }

        //数据处理
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> productCodeList = list.stream().map(SalesDatePeriodSummaryVo::getProductCode).distinct().collect(Collectors.toList());
            List<ProductVo> productVoList = productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));
            list.forEach(v->{
                if (productMap.containsKey(v.getProductCode())) {
                    ProductVo productVo = productMap.get(v.getProductCode());
                    v.setProductName(productVo.getProductName());
                    v.setProductBrandCode(productVo.getProductBrandCode());
                    v.setProductBrandName(productVo.getProductBrandName());
                    v.setProductCategoryCode(productVo.getProductCategoryCode());
                    v.setProductCategoryName(productVo.getProductCategoryName());
                    v.setProductItemCode(productVo.getProductLevelCode());
                    v.setProductItemName(productVo.getProductLevelName());
                }
                if (Objects.isNull(v.getWarehsOutDiscountAmtIncY())) {
                    v.setWarehsOutDiscountAmtIncY(BigDecimal.ZERO);
                }
            });
        }
        list = list.stream().filter(e->Objects.nonNull(e.getWarehsOutDiscountAmtIncY()) && BigDecimal.ZERO.compareTo(e.getWarehsOutDiscountAmtIncY()) < 0).collect(Collectors.toList());
        //均摊计算用
        if (CollectionUtils.isNotEmpty(list) && StringUtils.isNotEmpty(cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(SalesDatePeriodSummaryVo::getProductCode, SalesDatePeriodSummaryVo::getWarehsOutDiscountAmtIncY, (v1, v2) -> v2));
            redisService.set(cacheKey, JSONObject.toJSONString(map), 60 * 60 * 12);
        }
        return list;
    }

    @Override
    public SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto) {
        if (StringUtils.isNotEmpty(dto.getSalesMonth())) {
            dto.setSalesMonth(dto.getSalesMonth().replaceAll("-", ""));
        }
        return this.salesPerformanceMapper.findSalesAmountAndOutNumber(dto);
    }
}




