package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesPerformanceMapper;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceStatisDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.MonthEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceStatisVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 查询
 *
 * @author HuoJia
 */
@Slf4j
@Service
public class SalesPerformanceVoServiceImpl extends ServiceImpl<SalesPerformanceMapper, SalesPerformanceEntity>
        implements SalesPerformanceVoService {

    @Resource
    private SalesPerformanceMapper salesPerformanceMapper;

    /**
     * 查询一年的销售数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo>
     * @author huojia
     * @date 2023/2/13 14:06
     **/
    @Override
    public List<SalesPerformanceSumVo> listYearByConditions(SalesPerformanceDto dto) {
        List<String> monthList = MonthEnum.concertEnumToList();
        List<SalesPerformanceSumVo> salesPerformanceSumVos = new ArrayList<>();
        if (StringUtils.isNotBlank(dto.getSalesMonth())) {
            monthList = monthList.stream().filter(item -> item.equals(dto.getSalesMonth().substring(4))).collect(Collectors.toList());
        }
        log.info("查询一年的销售数据,dto.getSalesMonth() ==>:{}", dto.getSalesMonth());
        log.info("查询一年的销售数据,monthList ==>:{}", JSONObject.toJSONString(monthList));
        monthList.forEach(month -> {
//            dto.setSalesDate(salesDate + month);
//            String tableName = "tpm_sales_performance_" + dto.getSalesDate();
//            String tableName = "tpm_sales_performance";
//            Integer number = salesPerformanceMapper.isExist(tableName);
//            if (number > 0) {
            dto.setSalesMonth(dto.getSalesDate() + month);
            log.info("查询一年的销售数据,当前查询月份:{},查询参数:{}", dto.getSalesMonth(), dto);
            List<SalesPerformanceSumVo> salesPerformanceSums = this.salesPerformanceMapper.listByConditions(dto);
            if (!CollectionUtils.isEmpty(salesPerformanceSums)) {
                salesPerformanceSumVos.addAll(salesPerformanceSums);
            }
//            }
        });
        return salesPerformanceSumVos;
    }


    /**
     * 根据活动开始结束时间，零售商区域，统计此维度下的每个品牌的折扣实际销额
     *
     * @param dto 主体日销售数据筛选参数
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> statisSalesAmountByBrand(SalesPerformanceStatisDto dto) {
        if (Objects.isNull(dto.getActivityBeginDate()) || Objects.isNull(dto.getActivityEndDate())) {
            return Maps.newHashMap();
        }
        if (StringUtils.isBlank(dto.getSystemCode()) || StringUtils.isNotBlank(dto.getRegion())) {
            return Maps.newHashMap();
        }
        //将时间转换为字符串yyyyMMdd
        dto.setActivityBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyyMMdd, dto.getActivityBeginDate()));
        dto.setActivityEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyyMMdd, dto.getActivityEndDate()));
        //获取年月列表
        List<String> yearMonthList = DateUtil.getBetweenYearMonths(dto.getActivityBeginDate(), dto.getActivityEndDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(yearMonthList)) {
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> map = new HashMap<>();
        //循环查询表
        for (String s : yearMonthList) {
            dto.setYearMonthStr(s);
            List<SalesPerformanceStatisVo> list = this.salesPerformanceMapper.statisSalesAmountByBrand(dto);
            if (CollectionUtils.isEmpty(list)) {
                continue;
            }
            for (SalesPerformanceStatisVo vo : list) {
                if (map.containsKey(vo.getBrand())) {
                    BigDecimal b = map.get(vo.getBrand());
                    map.put(vo.getBrand(), b.add(vo.getStatisValue()));
                } else {
                    map.put(vo.getBrand(), vo.getStatisValue());
                }
            }
        }
        return map;
    }

    @Override
    public SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(dto.getSalesMonth())) {
            dto.setSalesMonth(dto.getSalesMonth().replaceAll("-", ""));
        }
        return this.salesPerformanceMapper.findSalesAmountAndOutNumber(dto);
    }

    @Override
    public List<SalesPerformanceVo> findSalesPerformanceSumVo(SalesPerformanceDto queryDto) {
        if (CollectionUtils.isEmpty(queryDto.getYearLyCollection()) &&
                CollectionUtils.isEmpty(queryDto.getRegionNameCollection()) &&
                CollectionUtils.isEmpty(queryDto.getSystemNameCollection())) {
            return Collections.emptyList();
        }
        Collection<String> systemNameCollection = queryDto.getSystemNameCollection();
        List<SalesPerformanceVo> result = new ArrayList<>();
        queryDto.getYearLyCollection().forEach(yearCol -> {
            queryDto.getRegionNameCollection().forEach(region -> {
                SalesPerformanceDto dto = new SalesPerformanceDto();
                dto.setYearCol(yearCol);
                dto.setRegion(region);
                dto.setSystemNameCollection(systemNameCollection);
                List<SalesPerformanceVo> sumVoList = salesPerformanceMapper.findSalesPerformanceSumVo(dto);
                if (CollectionUtil.isNotEmpty(sumVoList)) {
                    result.addAll(sumVoList);
                }
            });
        });
        return result;
    }

    @Override
    public BigDecimal findSalesAmount(SalesPerformanceDto dto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(dto.getSalesDate())) {
            dto.setSalesDate(dto.getSalesDate().replaceAll("-", ""));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(dto.getSalesBeginDate())) {
            dto.setSalesBeginDate(dto.getSalesBeginDate().replaceAll("-", ""));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(dto.getSalesEndDate())) {
            dto.setSalesEndDate(dto.getSalesEndDate().replaceAll("-", ""));
        }

        return this.salesPerformanceMapper.findSalesAmount(dto);
    }

    @Override
    public List<SalesPerformanceVo> findListForFR(List<SalesPerformanceDto> salesPerformanceDtos) {
        return this.salesPerformanceMapper.findListForFR(salesPerformanceDtos);
    }

    @Override
    public List<SalesPerformanceVo> findBusinessUnitSetTableForFR(List<SalesPerformanceDto> salesPerformanceDtos) {
        return this.salesPerformanceMapper.findBusinessUnitSetTableForFR(salesPerformanceDtos);
    }
}




